package com.bcxin.api.interfaces.tenants;

import com.bcxin.api.interfaces.commons.CommonImportResponse;
import com.bcxin.api.interfaces.tenants.requests.employees.BatchAssignImPermissionRequest;
import com.bcxin.api.interfaces.tenants.requests.employees.BatchMoveDepartmentEmployeeRequest;
import com.bcxin.api.interfaces.tenants.requests.DepartmentRequest;
import com.bcxin.api.interfaces.tenants.requests.ImportDepartmentRequest;
import com.bcxin.api.interfaces.tenants.responses.DepartmentGetResponse;
import com.bcxin.api.interfaces.tenants.responses.DepartmentTreeGetResponse;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
public interface DepartmentRpcProvider {
    Collection<DepartmentGetResponse> getDirectlySubDepartments(String organizationId, String parentId);

    Collection<DepartmentTreeGetResponse> getDepartments(String organizationId);

    DepartmentGetResponse getDepartment(String organizationId, String id);

    String create(String organizationId, DepartmentRequest request);

    void update(String organizationId, String id, DepartmentRequest request);

    void delete(String organizationId, String id);

    CommonImportResponse batchImport(String organizationId, String path, Collection<ImportDepartmentRequest> requests);

    void batchMove(String organizationId, BatchMoveDepartmentEmployeeRequest request);

    void batchImPermissions(String organizationId, BatchAssignImPermissionRequest request);

    void batchDelete(String organizationId,Collection<String> ids);

    void update(String organizationId, String id, int displayOrder);
}
