package com.bcxin.api.interfaces.tenants;

import java.util.Collection;

import org.springframework.stereotype.Component;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.commons.CommonImportResponse;
import com.bcxin.api.interfaces.tenants.criterias.ContractCriteria;
import com.bcxin.api.interfaces.tenants.requests.contracts.BatchImportContractRequest;
import com.bcxin.api.interfaces.tenants.requests.contracts.CreateContractRequest;
import com.bcxin.api.interfaces.tenants.requests.contracts.UpdateContractRequest;
import com.bcxin.api.interfaces.tenants.responses.ContractGetResponse;

@Component
public interface ContractRpcProvider {
    void create(String organizationId, CreateContractRequest request);

    void update(String organizationId, String id, UpdateContractRequest request);

    void delete(String organizationId, String id);

    Pagination<ContractGetResponse> find(String organizationId, ContractCriteria criteria);

    CommonImportResponse batchImport(String organizationId, String path, Collection<BatchImportContractRequest> requests);

}