package com.bcxin.api.interfaces.salary.res;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

import lombok.Data;

@Data
public class PayDistributionRes implements Serializable{
	
	/**
	 *  人数
	 */
	private Integer personCount=0;
	/**
	 * 范围
	 */
	private Integer  range;
	/**
	 * 范围值
	 */
	private String  rangeStr;
	/**
	 * 百分比
	 */
	private String  ratio;
	
	public List<Integer> assignRange(int flag){
		if(flag==1) {
			return Arrays.asList(0,3000);
		}
		if(flag==2) {
			return Arrays.asList(3000,5000);
		}
		if(flag==3) {
			return Arrays.asList(5000,8000);
		}
		if(flag==4) {
			return Arrays.asList(8000,10000);
		}
		if(flag==5) {
			return Arrays.asList(10000,15000);
		}
		if(flag==6) {
			return Arrays.asList(15000,20000);
		}
		if(flag==7) {
			return Arrays.asList(20000,50000);
		}
		return Arrays.asList(50000,Integer.MAX_VALUE);
	}
	public String getRangeStr(int flag) {
		StringBuffer sb  = new StringBuffer();
		sb.append(assignRange(flag).get(0));
		sb.append("-");
		sb.append(assignRange(flag).get(1));
		if(assignRange(flag).get(1)==3000) {
			sb=new StringBuffer("3000元以下"); 
		}
		if(assignRange(flag).get(0)==50000) {
			sb=new StringBuffer("50000以上"); 
		}
		return sb.toString() ;
	}
}
