package com.bcxin.api.interfaces.salary.req;

import java.math.BigDecimal;
import java.util.Date;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.bcxin.Infrastructures.components.models.ExcelModelAbstract;

import lombok.Data;
@Data
public class SalaryStatisticsHead extends ExcelModelAbstract{

	    /**
	    * 应发工资
	    */
		@ExcelProperty(index=2)
	    private BigDecimal shouldSalary;

	    /**
	    * 月份 202106 
	    */
		@ExcelProperty(index=0)
	    private String month;

	    /**
	    * 实发工资
	    */
		@ExcelProperty(index=3)
	    private BigDecimal actualSalary;

	    /**
	    * 个税总额
	    */
		@ExcelProperty(index=4)
	    private BigDecimal tax;




	    /**
	    * 计薪总人数
	    */
		@ExcelProperty(index=1)
	    private Integer totalPersonCount;

	    /**
	    * 薪资锁定时间
	    */
		@ExcelProperty(index=5)
	    @DateTimeFormat("yyyy/MM/dd")
	    private Date lockTime;
		
		@ExcelIgnore()
	    private String tabName;
		
		@ExcelIgnore()
	    private Long id;

	    public SalaryStatisticsHead() {
	    }
}
