package com.bcxin.api.interfaces.salary.req;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * @description 薪资组
 */
@Data
public class SalaryGroupSaveReq implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
    * id
    */
    private Long id;

    /**
    * 薪资组名称 
    */
    @NotNull
    private String groupName;

    /**
    * 算薪人员 
    */
    private String payEmp;
    /**
     * 部门
     */
    private List<String> depts=new ArrayList<String>();

    /**
    * 排除人员 
    */
    private String excludeEmp;

    /**
    * 计薪周期从当月的
    */
    private String cycleFrom;

    /**
    * 计薪周期到当月的
    */
    private String cycleTo;

    /**
    * 计薪月份 yyyy-MM
    */
    private String month;
    /**
     * 计薪月份 yyyy-MM
     */
    @NotNull
    private Integer monthType;

    /**
    * 发薪日 1 当月 2 次月
    */
    private Integer payMoth;

    /**
    * 发薪日 1-12号
    */
    private Integer payDay;

    /**
    * 日标准计薪时长 小时/ 天
    */
    private Integer payrollHour;

    /**
    * 备注 
    */
    private String remark;

    /**
    * 配薪方式 1 模板 2 复制已有薪资组规则 3 导入薪资规则
    */
    private String payWay;

    /**
    * 薪资规则 json 字段{ } 
    */
    private String payRule;

    /**
    * 状态 0草稿 1生效
    */
    @NotNull
    private Integer state;

    
    /**
     * 司日历
     */
    private String calendar;

    public SalaryGroupSaveReq() {}
}

