package com.bcxin.api.interfaces.salary.req;

import java.math.BigDecimal;
import java.util.Date;

import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.Infrastructures.components.models.ExcelModelAbstract;

import lombok.Data;
@Data
public class SalaryChangeRecordHead extends ExcelModelAbstract{
	  /**
	    * 员工号
	    */
	    @ExcelProperty("员工号")
	    private String employeeNo;
	    /**
	    * 员工名字 
	    */
	    @ExcelProperty("姓名")
	    private String name;
	    
	    // 证件类型 credentialType
	    @ExcelProperty("证件类型")
	    private Integer certiType;
	    // 证件号码 credentialNumber
	    @ExcelProperty("证件号码")
	    private String certiNo;	
	    // 部门 department
	    @ExcelProperty("部门")
	    private String dept;
	    // 岗位 position
	    @ExcelProperty("岗位")
	    private String post;
	    // 员工状态 status
	    @ExcelProperty("员工状态")
	    private Integer employState;
	    // 员工类型 OccupationType
	    @ExcelProperty("员工类型")
	    private Integer employType;
	    
	    /**
	    * 定调薪类型 1 定薪 2 调薪
	    */
	    @ExcelProperty("定调薪类型")
	    private Integer type;

	    /**
	    * 原因 
	    */
	    @ExcelProperty("调薪原因")
	    private String remark;


	    /**
	    * 生效时间
	    */
	    @ExcelProperty("生效日期")
	    private Date validTime;

	    /**
	    * 生效状态
	    */
	    @ExcelProperty("生效状态")
	    private Integer validState;

	    /**
	    * 经办人 
	    */
	    @ExcelProperty("经办人员")
	    private String handlerName;

	    /**
	    * 未调整前的总工资
	    */
	    @ExcelProperty("调整前汇总金额")
	    private BigDecimal unadjustedSalary;

	    /**
	    * 调整后汇总金额
	    */
	    @ExcelProperty("调整后汇总金额")
	    private BigDecimal justedSalary;

	    /**
	    * 调整比例
	    */
	    @ExcelProperty("调整比例（%）")
	    private String justedRatio;

	    public SalaryChangeRecordHead() {
	    }
}
