package com.bcxin.api.interfaces.salary.req;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotEmpty;

import lombok.Data;
@Data
public class HumanTotalCountReq implements Serializable{
	/**月份*/
	private String month;
	/**部门展示 1 展示末及部门  2 展示所有部门层级*/
	private String deptShow;
	/**部门*/
	@NotEmpty
	private List<String> depts;
	/**数据来源 1 智能算薪 2 税前工资算税*/
	private DtSource dtSource;
	
	 enum  DtSource{
		ONE("智能算薪",1),
		TWO("税前工资算税",2);
		private int index;
		private String name;
		private DtSource(String name, int index) {  
		        this.name = name;  
		        this.index = index;  
		    }
		

	    public static String getName(int index) {  
	        for (DtSource c : DtSource.values()) {  
	            if (c.getIndex() == index) {  
	                return c.name;  
	            }  
	        }  
	        return null;  
	    } 
		public int getIndex() {
			return index;
		}
		public void setIndex(int index) {
			this.index = index;
		}
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		} 
		
	}
}
