package com.bcxin.api.interfaces.salary.req;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.excel.annotation.ExcelProperty;

import lombok.Data;
@Data
public class HumanDetailHead implements Serializable {
	public final static Map<String, String> map;

    static {
        map = new HashMap<>();
        map.put("调薪（转正）后天数", "AfterChangeTotal");
        map.put("应税工资", "ShouldTaxTotal");
        map.put("基本工资", "BasicSalaryTotal");
        map.put("实发工资", "ActualSalaryTotal");
        map.put("餐补", "MealTotal");
        map.put("个人社保合计", "PInsTotal");
        map.put("岗位工资", "PostSalaryTotal");
        map.put("应出勤天数", "ShouldAttendTotal");
        map.put("实际出勤天数", "ActualAttendTotal");
        map.put("个人所得税", "TaxTotal");
        map.put("调薪（转正）前天数", "BeforeChangeDay");
        map.put("绩效奖金", "PerformSalaryTotal");
        map.put("通讯补贴", "TrafficBonusTotal");
        map.put("个人公积金", "PersonFundTotal");
        map.put("个人医疗保险", "PersonInsTotal");
        map.put("提成奖金", "BonusTotal");
        map.put("个人养老保险", "PersonOldTotal");
        map.put("个人失业保险", "LossWorkTotal");
    }
	@ExcelProperty("部门")
	private String dept;
	@ExcelProperty("人数")
	private String humanTotal;
	@ExcelProperty("调薪（转正）后天数")
	private String afterChangeTotal;
	@ExcelProperty("应税工资")
	private String shouldTaxTotal;
	@ExcelProperty("基本工资")
	private String basicSalaryTotal;
	@ExcelProperty("实发工资")
	private String actualSalaryTotal;
	@ExcelProperty("餐补")
	private String mealTotal;
	@ExcelProperty("个人社保合计")
	private String pInsTotal;
	@ExcelProperty("岗位工资")
	private String postSalaryTotal;
	@ExcelProperty("应出勤天数")
	private String shouldAttendTotal;
	@ExcelProperty("实际出勤天数")
	private String actualAttendTotal;
	@ExcelProperty("个人所得税")
	private String taxTotal;
	@ExcelProperty("调薪（转正）前天数")
	private String beforeChangeDay;
	@ExcelProperty("绩效奖金")
	private String performSalaryTotal;
	@ExcelProperty("通讯补贴")
	private String trafficBonusTotal;
	@ExcelProperty("个人公积金")
	private String personFundTotal;
	@ExcelProperty("个人医疗保险")
	private String personInsTotal;
	@ExcelProperty("提成奖金")
	private String bonusTotal;
	@ExcelProperty("个人养老保险")
	private String personOldTotal;
	@ExcelProperty("个人失业保险")
	private String lossWorkTotal;
	public void setValue( String head,String value ) throws Exception{
		String strategy = HumanDetailHead.map.get(head);
		if(strategy!=null) {
			Class<?> cls = HumanDetailHead.class;
			Method method = cls.getMethod("set"+strategy, String.class);
			method.invoke(this, value);
		}

	}
}
