package com.bcxin.api.interfaces.salary.cmd;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import org.springframework.format.annotation.DateTimeFormat;

import com.bcxin.api.interfaces.salary.req.PayrollVo;
import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;
@Data
public class PayrollSendCmd implements Serializable{
	
	/**薪资类型 0 工资 */
	private Integer salaryType=0;
	/**工资单名称*/
	private String payrollName;
	/**工资发放日期*/
	private String payrollDate;
	/**币种 0 表示人命币 */
	private Integer currency;
	/**员工识别码 0 证件号码  1 银行卡号 */
	@NotNull
	private Integer idCode;
	/**0 普通上传 1 智能上传 2 系统发送 */
	@NotNull
	private Integer upType;
	
	/**发送状态 0 待提交  1 待发送  2 部分发送  3 发送 */
	private Integer sendStatus=0;
	
	/**问候语*/
	private String greet;
	/**温馨提示*/
	private String hint;
	/**限时查看*/
	private Integer time;
	/**限时查看单位*/
	private int unit;
	/**持久 0 不持久  1 持久*/
	private boolean flag=false;
	@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm",timezone="GMT+8")
	private Date appointTime;
	
	/**薪资组ID*/
	private Long groupId;
	
	List<PayrollVo> details;
	
	
}
