package com.bcxin.api.interfaces.rbacs.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

@Getter
public class CategoryRequest extends RequestAbstract {
    private final String code;
    private final String name;
    private final String note;

    public CategoryRequest(String code,String name, String note) {
        this.code = code;
        this.name = name;
        this.note = note;
    }

    public static CategoryRequest create(String code, String name, String note) {
        return new CategoryRequest(code, name, note);
    }
}
