package com.bcxin.api.interfaces.rbacs;

import com.bcxin.api.interfaces.rbacs.requests.CreateRoleRequest;
import com.bcxin.api.interfaces.rbacs.requests.UpdateRoleRequest;
import com.bcxin.api.interfaces.rbacs.responses.RoleDetailGetResponse;
import com.bcxin.api.interfaces.rbacs.responses.RoleGetResponse;
import org.springframework.stereotype.Component;

import java.util.Collection;

@Component
public interface RbacRoleRpcProvider {
    void create(String refSubjectId, CreateRoleRequest request);

    void update(String refSubjectId,String id, UpdateRoleRequest request);

    void delete(String refSubjectId,String id);

    Collection<RoleGetResponse> getAll(String refSubjectId);

    RoleDetailGetResponse getById(String refSubjectId, String id);
}
