package com.bcxin.api.interfaces.rbacs;

import java.util.List;
import java.util.Map;

import com.bcxin.Infrastructures.Pagination;
import com.bcxin.api.interfaces.salary.req.ArchiveChangeReq;
import com.bcxin.api.interfaces.salary.req.ArchiveFixedReq;
import com.bcxin.api.interfaces.salary.req.ArchiveItemEditReq;
import com.bcxin.api.interfaces.salary.req.ArchivePageQueryReq;
import com.bcxin.api.interfaces.salary.res.ArchiveItemQueryRes;
import com.bcxin.api.interfaces.salary.res.ArchivePageQueryExport;
import com.bcxin.api.interfaces.salary.res.ArchivePageQueryRes;
import com.bcxin.api.interfaces.salary.res.ArchiveTotalQueryRes;

public interface ISalaryArchiveService {
	Pagination<ArchivePageQueryRes> queryArchlist(ArchivePageQueryReq req );
	
	List<ArchiveItemQueryRes> queryItem();
	
	void itemedit(List<ArchiveItemEditReq> req );
	
	void itemedel(String id );
	
	<T extends ArchiveFixedReq>ArchiveTotalQueryRes getTotalByBasic(T  req);
	
	ArchiveTotalQueryRes fixSalary(ArchiveFixedReq req);

	void changeSalary(ArchiveChangeReq req);
	
	ArchiveTotalQueryRes getFixedDetail(long id);
	
	void importFixedSalary(Map<String,Object> dto);

	void importChangeSalary(Map<String,Object> dto);

	List<ArchivePageQueryExport> export(ArchivePageQueryReq req);
}
