package com.bcxin.api.interfaces.identities.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import lombok.Getter;

@Getter
public class SignInResponse extends ResponseAbstract {
    private final String token;
    private final String name;
    private final String telephone;

    protected SignInResponse(String token, String name, String telephone) {
        this.token = token;
        this.name = name;
        this.telephone = telephone;
    }

    public static SignInResponse create(String token, String name, String telephone) {
        return new SignInResponse(token, name, telephone);
    }
}
