package com.bcxin.api.interfaces.commons;

import lombok.Getter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

@Getter
public class ImportedResponseItem implements Serializable {
    private final int index;
    private final Map<String, Object> parameters;
    private final String result;

    public boolean IsSuccess() {
        return !StringUtils.hasLength(result);
    }

    public ImportedResponseItem(int index, Map<String, Object> parameters, String result) {
        this.parameters = parameters;
        this.result = result;
        this.index = index;
    }

    public static ImportedResponseItem create(int index, Map<String, Object> parameters, String result) {
        return new ImportedResponseItem(index, parameters, result);
    }
}
