/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.schedule;

import cn.hutool.core.util.StrUtil;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.domain.SysConfig;
import com.bcxin.auth.system.mapper.DataSyncLogMapper;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.util.DateUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dataSyncFileTask")
public class DataSyncFileTask {
    private static Logger logger = LoggerFactory.getLogger(DataSyncFileTask.class);
    @Autowired
    ISysConfigService configService;
    @Autowired
    ConfigUtil configUtil;
    @Autowired
    DataSyncLogMapper dataSyncLogMapper;
    private boolean lock = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.lock) {
            return;
        }
        this.lock = true;
        try {
            if (this.configUtil.isIntranet()) {
                String beginDateStr = this.configService.selectConfigByKey("DATASYNC_DATE");
                Date beginDate = DateUtil.getBeginDayOfYesterday();
                if (StrUtil.isNotEmpty((CharSequence)beginDateStr)) {
                    beginDate = DateUtil.convertStringToDate(beginDateStr);
                }
                List<Date> dateList = DateUtil.getBetweenDates(beginDate, new Date());
                ArrayList<DataSyncLog> logList = new ArrayList<DataSyncLog>();
                DataSyncLog dataSyncLog = null;
                for (Date date : dateList) {
                    File[] files;
                    String dirFilePath = BMSConfig.getDataSyncProfile() + DateUtil.convertDateToString(date, "yyyy-MM-dd");
                    File dirFile = new File(dirFilePath);
                    if (!dirFile.exists()) continue;
                    for (File file : files = dirFile.listFiles()) {
                        dataSyncLog = this.dataSyncLogMapper.findByFilePath(file.getAbsolutePath().replaceAll("\\\\", "/"));
                        if (dataSyncLog != null) continue;
                        dataSyncLog = new DataSyncLog();
                        dataSyncLog.setIsDelete("0");
                        dataSyncLog.setBasePath(BMSConfig.getDataSyncProfile());
                        dataSyncLog.setFilePath(file.getAbsolutePath().replaceAll("\\\\", "/"));
                        dataSyncLog.setFileName(file.getName());
                        dataSyncLog.setUrl("dataSync/getResource?path=" + dataSyncLog.getFilePath().replace(BMSConfig.getDataSyncProfile(), ""));
                        dataSyncLog.setBusinessType("0");
                        dataSyncLog.setDataSyncState("0");
                        dataSyncLog.setCreateTime(new Date());
                        dataSyncLog.setUpdateTime(new Date());
                        logList.add(dataSyncLog);
                    }
                }
                if (logList.size() > 0) {
                    int limit = 100;
                    int count = new Double(Math.ceil((double)logList.size() * 1.0 / (double)limit)).intValue();
                    List<DataSyncLog> subList = null;
                    for (int i = 0; i < count; ++i) {
                        subList = logList.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                        this.dataSyncLogMapper.saveBatch(subList);
                    }
                }
                SysConfig dsDateConfig = new SysConfig();
                dsDateConfig.setConfigKey("DATASYNC_DATE");
                dsDateConfig.setConfigValue(DateUtil.getYesterday());
                this.configService.updateConfigByKey(dsDateConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
        finally {
            this.lock = false;
        }
    }
}

