package com.bcxin.obpm.ministerial;

import com.bcxin.obpm.annotation.MinisterialAttr;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.math.BigDecimal;

/**
 * @author zhangyutong
 */
@Component
public class YuanDataFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        String yuan = (String) data;
        if (yuan != null) {
            BigDecimal bigDecimal = new BigDecimal(yuan);
            bigDecimal=bigDecimal.multiply(BigDecimal.valueOf(10000));
            return String.valueOf(bigDecimal.setScale(4,BigDecimal.ROUND_HALF_UP));
        }
        return null;
    }

    public static void main(String[] args) {
        BigDecimal bigDecimal=new BigDecimal("0.0100000000");
        bigDecimal=bigDecimal.multiply(BigDecimal.valueOf(10000));
        System.out.println(String.valueOf(bigDecimal.setScale(4,BigDecimal.ROUND_HALF_UP)));

    }
}
