/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.auth.common.utils.IdWorker;
import com.bcxin.auth.common.utils.PDFUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.vo.CommonClass;
import com.bcxin.auth.system.domain.CertificatePaths;
import com.bcxin.auth.system.domain.ComCerDto;
import com.bcxin.auth.system.domain.HonorCertificate;
import com.bcxin.auth.system.domain.SecurityService;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.auth.system.util.FileUtil;
import com.bcxin.obpm.dto.PdfChangeDTO;
import com.bcxin.obpm.service.CreatePDFService;
import com.bcxin.obpm.service.StampService;
import com.bcxin.obpm.util.DateUtil;
import com.github.pagehelper.util.StringUtil;
import com.itextpdf.text.DocumentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CreatePDFServiceImpl
implements CreatePDFService {
    protected Logger logger = LoggerFactory.getLogger(CreatePDFServiceImpl.class);
    @Autowired
    private ISysConfigService configService;
    @Value(value="${bcxin.profile}")
    private String baseFolder;
    @Value(value="${bcxin.storage.root}")
    String rootPath;
    @Resource
    private ConfigUtil configUtil;
    @Autowired
    IdWorker idWorker;
    @Autowired
    private StampService stampService;

    @Override
    public String createPDF(ComCerDto comCerDto, String businesstype) throws Exception {
        ComCerDto printData;
        String path = "";
        String templatePath = CreatePDFServiceImpl.class.getResource("/").toString();
        String ConfigValue = this.configService.selectConfigByKey("CURRENT_PROVINCE");
        String companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6.pdf";
        String companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6.pdf";
        Date now = new Date();
        String companyCertificate1FileName = now.getTime() + "_companyCertificate1.pdf";
        String companyCertificate2FileName = now.getTime() + "_companyCertificate2.pdf";
        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "pdf/" + dirDate + "/";
        String pdfPath = this.baseFolder + filePath;
        String companyCertificate2PathChange = pdfPath + "change_" + companyCertificate2FileName;
        File pdfFile = new File(pdfPath);
        if (!pdfFile.exists()) {
            pdfFile.mkdirs();
        }
        String companyCertificate1Path = pdfPath + companyCertificate1FileName;
        String companyCertificate2Path = pdfPath + companyCertificate2FileName;
        if ("001".equals(businesstype) && null != (printData = this.getcompanyCertificateData(comCerDto))) {
            if (StringUtil.isEmpty((String)printData.getGsdz_2())) {
                companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6_single.pdf";
                companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_single.pdf";
            }
            if (StringUtil.isNotEmpty((String)printData.getGsdz_3())) {
                companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6-3.pdf";
            }
            if (printData.getGsmc().length() > 15) {
                companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_c.pdf";
            }
            if (comCerDto.getZf().equals("f")) {
                if (printData.getPdfChangeDTOList() != null) {
                    ArrayList commonClassArrayList = new ArrayList();
                    printData.getPdfChangeDTOList().forEach(pdfChangeDTO -> {
                        CommonClass commonClass = CreatePDFServiceImpl.parsePdfClass(pdfChangeDTO);
                        commonClassArrayList.add(commonClass);
                    });
                    PDFUtils.addPDFChange((String)companyCertificate2_Path, (String)companyCertificate2PathChange, commonClassArrayList);
                    PDFUtils.createPDFForTemplate((String)companyCertificate2PathChange, (String)companyCertificate2Path, (Object)printData);
                } else {
                    PDFUtils.createPDFForTemplate((String)companyCertificate2_Path, (String)companyCertificate2Path, (Object)printData);
                }
                if (null != ConfigValue && "610000".equals(ConfigValue)) {
                    this.stampService.addStamp(companyCertificate2Path, "2");
                }
                path = this.baseFolder + filePath + companyCertificate2FileName;
            } else {
                PDFUtils.createPDFForTemplate((String)companyCertificate1_Path, (String)companyCertificate1Path, (Object)printData);
                if (null != ConfigValue && "610000".equals(ConfigValue)) {
                    this.stampService.addStamp(companyCertificate1Path, "1");
                }
                path = this.baseFolder + filePath + companyCertificate1FileName;
            }
        }
        return path;
    }

    @Override
    public Map<String, String> createSecurityServicePDF(SecurityService securityService) throws Exception {
        String templatePath = CreatePDFServiceImpl.class.getResource("/").toString();
        String companyCertificate1_Path = templatePath + "pdfTemplate/bj_companyCertificate-z.pdf";
        String companyCertificate2_Path = templatePath + "pdfTemplate/bj_companyCertificate-f.pdf";
        Date now = new Date();
        String companyCertificateFileName_z = securityService.getGsmc() + "\u6b63\u672c" + now.getTime() + ".pdf";
        String companyCertificateFileName_f = securityService.getGsmc() + "\u526f\u672c" + now.getTime() + ".pdf";
        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "pdf/" + dirDate + "/";
        String pdfPath = this.rootPath + filePath;
        File pdfFile = new File(pdfPath);
        if (!pdfFile.exists()) {
            pdfFile.mkdirs();
        }
        String companyCertificate1Path = pdfPath + companyCertificateFileName_z;
        String companyCertificate2Path = pdfPath + companyCertificateFileName_f;
        SecurityService printData = this.parseCompanyCertificateData(securityService);
        HashMap<String, String> urlPath = new HashMap<String, String>();
        PDFUtils.createPDF((String)companyCertificate1_Path, (String)companyCertificate1Path, (Object)printData);
        urlPath.put("z", "/uploads/" + filePath + companyCertificateFileName_z);
        PDFUtils.createPDF((String)companyCertificate2_Path, (String)companyCertificate2Path, (Object)printData);
        urlPath.put("f", "/uploads/" + filePath + companyCertificateFileName_f);
        return urlPath;
    }

    @Override
    public List<HonorCertificate> createHonorCertificatePDF(List<HonorCertificate> honorCertificates) throws Exception {
        if (honorCertificates.size() == 0) {
            return honorCertificates;
        }
        String templatePath = CreatePDFServiceImpl.class.getResource("/").toString();
        String honorCertificate_Path = templatePath + "pdfTemplate/honorCertificate.pdf";
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "pdf/" + dirDate + "/";
        String pdfPath = this.baseFolder + filePath;
        File pdfFile = new File(pdfPath);
        if (!pdfFile.exists()) {
            pdfFile.mkdirs();
        }
        honorCertificates.forEach(honorCertificate -> {
            String honorCertificateFileName = honorCertificate.getName() + now.getTime() + ".pdf";
            String honorCertificatePath = pdfPath + honorCertificateFileName;
            try {
                PDFUtils.createPDF((String)honorCertificate_Path, (String)honorCertificatePath, (Object)honorCertificate);
                honorCertificate.setPdfUrl("/manage/cer/getResource?path=" + honorCertificatePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        });
        return honorCertificates;
    }

    ComCerDto getcompanyCertificateData(ComCerDto comCerDto) {
        ComCerDto printData = new ComCerDto();
        if (StringUtil.isNotEmpty((String)comCerDto.getZczb())) {
            printData.setZczb(CreatePDFServiceImpl.digitUppercase(Double.parseDouble(comCerDto.getZczb())));
        }
        if (StringUtil.isNotEmpty((String)comCerDto.getPzwh())) {
            printData.setPzwh(comCerDto.getPzwh().replace("\u3010", "[").replace("\u3011", "]"));
        }
        if (StringUtil.isNotEmpty((String)comCerDto.getGsmc())) {
            printData.setGsmc(comCerDto.getGsmc());
        }
        if (StringUtil.isNotEmpty((String)comCerDto.getFrmc())) {
            printData.setFrmc(comCerDto.getFrmc());
        }
        try {
            printData.setXkzh(comCerDto.getXkzh().substring(0, comCerDto.getXkzh().indexOf("2")) + " " + comCerDto.getXkzh().substring(comCerDto.getXkzh().indexOf("2")));
        }
        catch (Exception e) {
            printData.setXkzh(comCerDto.getXkzh().substring(0, comCerDto.getXkzh().indexOf("\u670d") + 1) + " " + comCerDto.getXkzh().substring(comCerDto.getXkzh().indexOf("\u670d") + 1));
        }
        printData.setXkzh(printData.getXkzh() != null && !printData.getXkzh().endsWith("\u53f7") ? printData.getXkzh() + "\u53f7" : printData.getXkzh());
        if (null != comCerDto.getFzrq()) {
            printData.setFzrqn(comCerDto.getFzrq().substring(0, 4));
            printData.setFzrqy(comCerDto.getFzrq().substring(5, 7));
            printData.setFzrqr(comCerDto.getFzrq().substring(8, 10));
        }
        if (null != comCerDto.getManagement()) {
            String fwfw = comCerDto.getManagement();
            if (null != fwfw && fwfw.length() > 19) {
                printData.setManagement(fwfw.substring(0, 19));
                printData.setManagement2(fwfw.substring(19));
            } else {
                printData.setManagement(fwfw);
            }
            if (null != fwfw && fwfw.length() > 19) {
                printData.setManagement_1(fwfw.substring(0, 19));
                printData.setManagement_2(fwfw.substring(19));
            } else {
                printData.setManagement_1(fwfw);
            }
        }
        if (null != comCerDto.getGsdz() && comCerDto.getGsdz().length() > 16) {
            printData.setGsdz_1(comCerDto.getGsdz().substring(0, 16));
            printData.setGsdz_2(comCerDto.getGsdz().substring(16));
            if (comCerDto.getGsdz().length() > 34) {
                printData.setGsdz_2(comCerDto.getGsdz().substring(16, 32));
                printData.setGsdz_3(comCerDto.getGsdz().substring(32));
            }
        } else {
            printData.setGsdz_1(comCerDto.getGsdz());
        }
        if (null != comCerDto.getGsdz() && comCerDto.getGsdz().length() > 20) {
            printData.setGsdz(comCerDto.getGsdz().substring(0, 20));
            printData.setGsdz2(comCerDto.getGsdz().substring(20));
        } else {
            printData.setGsdz(comCerDto.getGsdz());
        }
        if (null != comCerDto.getPdfChangeDTOList() && comCerDto.getPdfChangeDTOList().size() > 0) {
            printData.setPdfChangeDTOList(comCerDto.getPdfChangeDTOList());
        }
        return printData;
    }

    private SecurityService parseCompanyCertificateData(SecurityService securityService) {
        if (null != securityService.getGsdz() && securityService.getGsdz().length() > 20) {
            securityService.setGsdz1(securityService.getGsdz());
        } else {
            securityService.setGsdz1(securityService.getGsdz());
        }
        if (null != securityService.getGsdz() && securityService.getGsdz().length() > 16) {
            securityService.setGsdz_1(securityService.getGsdz());
        } else {
            securityService.setGsdz_1(securityService.getGsdz());
        }
        if (null != securityService.getFzrq()) {
            securityService.setFzrqn(securityService.getFzrq().substring(0, 4));
            securityService.setFzrqy(securityService.getFzrq().substring(5, 7));
            securityService.setFzrqr(securityService.getFzrq().substring(8, 10));
        }
        if (null != securityService.getManagement()) {
            securityService.setManagement(this.formatManagement(securityService.getManagement()));
        }
        return securityService;
    }

    public static String digitUppercase(double v) {
        String UNIT = "\u4e07\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u5143\u89d2\u5206";
        String DIGIT = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
        double MAX_VALUE = 9.99999999999999E12;
        if ((v *= 10000.0) < 0.0 || v > MAX_VALUE) {
            return "\u53c2\u6570\u975e\u6cd5!";
        }
        long l = Math.round(v * 100.0);
        if (l == 0L) {
            return "\u96f6\u5143";
        }
        String strValue = l + "";
        int i = 0;
        int j = UNIT.length() - strValue.length();
        String rs = "";
        boolean isZero = false;
        while (i < strValue.length()) {
            char ch = strValue.charAt(i);
            if (ch == '0') {
                isZero = true;
                if (UNIT.charAt(j) == '\u4ebf' || UNIT.charAt(j) == '\u4e07' || UNIT.charAt(j) == '\u5143') {
                    rs = rs + UNIT.charAt(j);
                    isZero = false;
                }
            } else {
                if (isZero) {
                    rs = rs + "\u96f6";
                    isZero = false;
                }
                rs = rs + DIGIT.charAt(ch - 48) + UNIT.charAt(j);
            }
            ++i;
            ++j;
        }
        rs = rs.replaceAll("\u4ebf\u4e07", "\u4ebf");
        return rs;
    }

    String formatManagement(String fwfw) {
        if (StringUtil.isEmpty((String)fwfw)) {
            return "";
        }
        StringBuffer management = new StringBuffer();
        String[] orders = new String[]{"01", "02", "03", "04", "05", "06", "07", "09", "08"};
        String[] ss = fwfw.split(";");
        for (int j = 0; j < orders.length; ++j) {
            for (int i = 0; i < ss.length; ++i) {
                if (!orders[j].equals(ss[i])) continue;
                if ("01".equals(ss[i])) {
                    management.append("\u95e8\u536b\u3001");
                    continue;
                }
                if ("02".equals(ss[i])) {
                    management.append("\u5de1\u903b\u3001");
                    continue;
                }
                if ("03".equals(ss[i])) {
                    management.append("\u5b88\u62a4\u3001");
                    continue;
                }
                if ("05".equals(ss[i])) {
                    management.append("\u968f\u8eab\u62a4\u536b\u3001");
                    continue;
                }
                if ("04".equals(ss[i])) {
                    if ("11".equals(this.configUtil.getCurrentNative())) {
                        management.append("\u6b66\u88c5\u62bc\u8fd0\u3001");
                        continue;
                    }
                    management.append("\u62bc\u8fd0\u3001");
                    continue;
                }
                if ("07".equals(ss[i])) {
                    if ("11".equals(this.configUtil.getCurrentNative())) continue;
                    management.append("\u533a\u57df\u79e9\u5e8f\u7ef4\u62a4\u3001");
                    continue;
                }
                if ("06".equals(ss[i])) {
                    management.append("\u5b89\u5168\u68c0\u67e5\u3001");
                    continue;
                }
                if ("08".equals(ss[i])) {
                    management.append("\u5b89\u5168\u98ce\u9669\u8bc4\u4f30\u3001");
                    continue;
                }
                if ("09".equals(ss[i])) {
                    management.append("\u5b89\u5168\u6280\u672f\u9632\u8303\u3001");
                    continue;
                }
                if (!"10".equals(ss[i]) || "11".equals(this.configUtil.getCurrentNative())) continue;
                management.append("\u5176\u4ed6");
            }
        }
        return management.toString().substring(0, management.toString().length() - 1);
    }

    public static CommonClass parsePdfClass(PdfChangeDTO pdfChangeDTO) {
        CommonClass commonClass = new CommonClass();
        commonClass.setField1(pdfChangeDTO.getProject());
        commonClass.setField2(pdfChangeDTO.getAfterChange());
        commonClass.setField3(pdfChangeDTO.getTime());
        return commonClass;
    }

    @Override
    public List<String> mergePdfServer(CertificatePaths certificatePaths) throws Exception {
        this.logger.info("mergePdfServer certificatePaths: {}", (Object)JSON.toJSONString((Object)certificatePaths));
        String[] paths = certificatePaths.getPaths();
        if (paths == null || paths.length == 0) {
            throw new FileNotFoundException("Font paths not found: " + JSON.toJSONString((Object)certificatePaths));
        }
        ArrayList<String> result = new ArrayList<String>();
        List<String> list = Arrays.asList(paths);
        IntStream.range(0, list.size()).filter(i -> i % 2 == 0).forEach(i -> {
            String outpdf = this.tempDownload("");
            this.logger.info("mergePdfServer outpdf: {}", (Object)outpdf);
            if (i + 1 < list.size()) {
                String inpdf2;
                String inpdf1 = (String)list.get(i);
                if (!inpdf1.contains(this.rootPath)) {
                    inpdf1 = this.rootPath + inpdf1;
                }
                if (!(inpdf2 = (String)list.get(i + 1)).contains(this.rootPath)) {
                    inpdf2 = this.rootPath + inpdf2;
                }
                float bl1 = 1.05f;
                float bl2 = 1.05f;
                if (!inpdf1.contains("C6101")) {
                    bl1 = 1.0f;
                }
                if (!inpdf2.contains("C6101")) {
                    bl2 = 1.0f;
                }
                inpdf1 = this.tempDownload(inpdf1);
                inpdf2 = this.tempDownload(inpdf2);
                this.logger.info("mergePdfServer inpdf1: {}", (Object)inpdf1);
                this.logger.info("mergePdfServer inpdf2: {}", (Object)inpdf2);
                try {
                    PDFUtils.mergePdf1((String)inpdf1, (String)inpdf2, (String)outpdf, (float)bl1, (float)bl2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                result.add(this.configUtil.getLocalHostURL() + "/manage/cer/viewResource?path=" + outpdf);
            } else {
                String inpdf1 = (String)list.get(i);
                if (!inpdf1.contains(this.rootPath)) {
                    inpdf1 = this.rootPath + inpdf1;
                }
                float bl1 = 1.05f;
                if (!inpdf1.contains("C6101")) {
                    bl1 = 1.0f;
                }
                inpdf1 = this.tempDownload(inpdf1);
                this.logger.info("mergePdfServer inpdf1: {}", (Object)inpdf1);
                try {
                    PDFUtils.mergePdf1((String)inpdf1, (String)"", (String)outpdf, (float)bl1, (float)0.0f);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                result.add(this.configUtil.getLocalHostURL() + "/manage/cer/viewResource?path=" + outpdf);
            }
        });
        return result;
    }

    private String tempDownload(String url) {
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "temp/" + dirDate + "/";
        String pdfPath = this.baseFolder + filePath + this.idWorker.nextId() + ".pdf";
        if (StringUtils.isNotEmpty((String)url)) {
            try {
                FileUtil.downloadFile1(url, pdfPath);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return pdfPath;
    }

    public static void main(String[] args) throws Exception {
        String pdfPath = "https://bcxinsaasprod.baibaodun.cn:443/upload%2Fcommon%2F2025-06-10%2F50a1a054-5602-4ea8-b306-92e099e11a07.pdf";
        String inpdf1 = "C:\\Users\\Administrator\\Downloads\\C610100queueId_14423.pdf";
        String inpdf2 = "C:\\Users\\Administrator\\Downloads\\C610700queueId_3806.pdf";
        String outpdf = "D:\\ase\\temp\\2025-06-10\\20250312171107.pdf";
        float bl1 = 1.05f;
        float bl2 = 1.05f;
        if (!inpdf1.contains("C6101")) {
            bl1 = 1.0f;
        }
        if (!inpdf2.contains("C6101")) {
            bl2 = 1.0f;
        }
        PDFUtils.mergePdf1((String)inpdf1, (String)inpdf2, (String)outpdf, (float)bl1, (float)bl2);
    }
}

