/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.exception.BusinessException;
import com.bcxin.auth.common.utils.bean.BeanUtils;
import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.dto.datasync.DataSyncDto;
import com.bcxin.auth.system.mapper.DataSyncLogMapper;
import com.bcxin.auth.system.service.IDataSyncLogService;
import com.bcxin.auth.system.util.FileUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSyncLogServiceImpl
implements IDataSyncLogService {
    Logger logger = LoggerFactory.getLogger(DataSyncLogServiceImpl.class);
    @Autowired
    private DataSyncLogMapper dataSyncLogMapper;

    @Override
    public int delete(DataSyncLog dataSyncLog) {
        dataSyncLog.setUpdateTime(new Date());
        return this.dataSyncLogMapper.delete(dataSyncLog);
    }

    @Override
    public int save(DataSyncLog dataSyncLog) {
        if (dataSyncLog.getId() == null) {
            dataSyncLog.setCreateTime(new Date());
        } else {
            DataSyncLog dbDataSyncLog = this.dataSyncLogMapper.findById(dataSyncLog.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)dataSyncLog), (Object)((Object)dbDataSyncLog), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbDataSyncLog), (Object)((Object)dataSyncLog), (Boolean)false);
        }
        dataSyncLog.setUpdateTime(new Date());
        return this.dataSyncLogMapper.save(dataSyncLog);
    }

    @Override
    public void callback(DataSyncLog dataSyncLog) {
        DataSyncLog dbDataSyncLog = this.dataSyncLogMapper.findByMsgId(dataSyncLog.getMsgId());
        if (dbDataSyncLog != null) {
            dbDataSyncLog.setDataSyncState("2");
            dbDataSyncLog.setUpdateTime(new Date());
            this.dataSyncLogMapper.save(dbDataSyncLog);
        }
    }

    @Override
    public void receive(DataSyncDto dataSyncDto) throws Exception {
        DataSyncLog dataSyncLog = (DataSyncLog)((Object)JSON.parseObject((String)dataSyncDto.getData(), DataSyncLog.class));
        try {
            FileUtil.downloadFile(dataSyncDto.getFilePaths(), dataSyncLog.getFilePath().replace(dataSyncLog.getBasePath(), BMSConfig.getDataSyncProfile()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + dataSyncDto.getFilePaths());
        }
        dataSyncLog.setDataSyncState("1");
        dataSyncLog.setErrorInfo(null);
        dataSyncLog.setUpdateTime(new Date());
        this.dataSyncLogMapper.save(dataSyncLog);
    }

    @Override
    public DataSyncLog findById(Long id) {
        return this.dataSyncLogMapper.findById(id);
    }

    @Override
    public List<DataSyncLog> findByBatchId(List<DataSyncLog> list) {
        return this.dataSyncLogMapper.findByBatchId(list);
    }

    @Override
    public void updateSelective(DataSyncLog dataSyncLog) {
        dataSyncLog.setUpdateTime(new Date());
        this.dataSyncLogMapper.updateSelective(dataSyncLog);
    }
}

