/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.utils.DES3;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.IdWorker;
import com.bcxin.auth.common.utils.file.FileUtils;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.mapper.TenantUserMapper;
import com.bcxin.obpm.service.ITenantUserService;
import com.bcxin.obpm.util.ComInterfaceUtil;
import com.bcxin.obpm.util.JwtUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TenantUserServiceImpl
implements ITenantUserService {
    private static Logger logger = LoggerFactory.getLogger(TenantUserServiceImpl.class);
    @Autowired
    ConfigUtil configUtil;
    @Autowired
    IdWorker idWorker;
    @Autowired
    private TenantUserMapper tenantUserMapper;
    @Resource
    private ComInterfaceUtil comInterfaceUtil;

    @Override
    public int updateAuthStatus(AuthLog authLog) {
        return this.tenantUserMapper.updateAuthStatus(authLog);
    }

    @Override
    public List<AuthLog> queryUnAuth(String idNumber) {
        List<AuthLog> list = this.tenantUserMapper.queryUnAuth(idNumber, this.configUtil.isGSDB());
        for (AuthLog dbAuthLog : list) {
            if (!StrUtil.isNotEmpty((CharSequence)dbAuthLog.getImgPath())) continue;
            dbAuthLog.setImgPath(dbAuthLog.getImgPath().replace("\\\"", "\""));
        }
        return list;
    }

    @Override
    public void updateBatchAuthStatus(List<AuthLog> list) {
        if (this.configUtil.isGSDB()) {
            this.tenantUserMapper.updateBatchAuthStatusForGS(list);
        } else {
            this.tenantUserMapper.updateBatchAuthStatus(list);
        }
        if (this.configUtil.isPolice() && !this.configUtil.isIntranet()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("authList", JwtUtil.createJwt(JSON.toJSONString(list)));
            this.comInterfaceUtil.callInterface("/auth/updateBatch", paramMap);
        }
    }

    @Override
    public void updateBatchAuthStatusToCom(List<AuthLog> list) {
        if (this.configUtil.isPolice() && !this.configUtil.isIntranet()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("authList", JwtUtil.createJwt(JSON.toJSONString(list)));
            this.comInterfaceUtil.callInterface("/auth/updateBatch", paramMap);
        }
    }

    @Override
    public void updateBatch(List<AuthLog> list) {
        this.tenantUserMapper.updateBatchAuthStatus(list);
    }

    @Override
    public List<AuthLog> selectList(AuthLog authLog) {
        List<AuthLog> list = this.tenantUserMapper.selectList(authLog);
        for (AuthLog dbAuthLog : list) {
            if (!StrUtil.isNotEmpty((CharSequence)dbAuthLog.getImgPath())) continue;
            dbAuthLog.setImgPath(dbAuthLog.getImgPath().replace("\\\"", "\""));
        }
        return list;
    }

    @Override
    public void dataSyncFile(AuthLog authLog) throws Exception {
        List<AuthLog> logList = this.tenantUserMapper.findAuthList(authLog);
        if (logList.size() > 0) {
            try {
                String content = DES3.encode((String)JSON.toJSONStringWithDateFormat(logList, (String)DateUtils.YYYY_MM_DD_HH_MM_SS, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                String fileName = "AuthLog_" + DateUtils.dateTimeNow((String)DateUtils.HHMMSS) + "_" + this.idWorker.nextId();
                String filepath = FileUtils.writeTxtFile((String)content, (String)fileName, (String)BMSConfig.getTempPath());
                String zipPath = BMSConfig.getDataSyncProfile() + DateUtils.getDate() + File.separator;
                File file = new File(zipPath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    file.mkdirs();
                }
                zipPath = zipPath + fileName + ".zip";
                FileUtils.zipFile((String)filepath, (String)zipPath);
                FileUtils.deleteFile((String)filepath);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u751f\u6210\u540c\u6b65\u6587\u4ef6\u5f02\u5e38\uff1a{}", (Throwable)e);
                throw e;
            }
        }
    }
}

