/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.schedule;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpMode;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.IdWorker;
import com.bcxin.auth.common.utils.IdcardUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.utils.file.FileUtils;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.service.IObpmSecurityManService;
import java.io.Closeable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="authTask")
public class AuthTask {
    private static Logger logger = LoggerFactory.getLogger(AuthTask.class);
    @Autowired
    ISysConfigService configService;
    @Autowired
    ConfigUtil configUtil;
    @Autowired
    IObpmSecurityManService obpmSecurityManService;
    @Resource
    IdWorker idWorker;

    private List<AuthLog> comparisonTest(List<AuthLog> list) {
        for (AuthLog authLog : list) {
            String num = authLog.getIdNumber().substring(authLog.getIdNumber().length() - 1);
            if (num.equals("4") || num.equals("5") || num.equals("6") || num.equals("7") || num.equals("8")) {
                authLog.setAuthStatus("3");
                authLog.setAuthResult("\u6d4b\u8bd5--\u8ba4\u8bc1\u901a\u8fc7");
            } else {
                authLog.setAuthStatus("2");
                authLog.setAuthResult("\u6d4b\u8bd5--\u59d3\u540d\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
            }
            authLog.setAuthDate(new Date());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AuthLog> validateResult(List<AuthLog> allAuthLogs) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        String startDate = format.format(DateUtils.getNowDate());
        List noPhotoList = Collections.synchronizedList(new ArrayList());
        List<AuthLog> resultList = Collections.synchronizedList(new ArrayList());
        try {
            if (!this.configUtil.isIntranet()) return resultList;
            logger.error("\u5f00\u59cb\u5b9e\u540d\u8ba4\u8bc1-----------------" + startDate);
            logger.error("\u5f85\u8ba4\u8bc1\u6570\u636e" + allAuthLogs.size());
            List<AuthLog> authList = Collections.synchronizedList(new ArrayList());
            List<String> filePaths = Collections.synchronizedList(new ArrayList());
            if (!CollectionUtils.isEmpty(allAuthLogs)) {
                if (this.configUtil.isTest()) {
                    authList.addAll(allAuthLogs);
                } else {
                    try {
                        this.splitAndExecuteAction(allAuthLogs, 100, list -> {
                            for (AuthLog authLog : allAuthLogs) {
                                if (!IdcardUtils.validateCard((String)authLog.getIdNumber())) {
                                    logger.error("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u7b26\u5408\u89c4\u8303,\u8ba4\u8bc1\u5931\u8d25:{}", (Object)authLog.getIdNumber());
                                    authLog.setAuthResult("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u7b26\u5408\u89c4\u8303,\u8ba4\u8bc1\u5931\u8d25");
                                    authLog.setAuthStatus("2");
                                    authLog.setAuthDate(DateUtils.getNowDate());
                                    noPhotoList.add(authLog);
                                    continue;
                                }
                                if (StringUtils.isEmpty((String)authLog.getImgPath())) {
                                    logger.error("\u4e00\u5bf8\u7167\u7247\u4e3a\u7a7a\uff0c\u8ba4\u8bc1\u5931\u8d25:{}", (Object)authLog.getIdNumber());
                                    authLog.setAuthResult("\u672a\u4e0a\u4f20\u4e00\u5bf8\u7167\uff0c\u8ba4\u8bc1\u5931\u8d25");
                                    authLog.setAuthStatus("2");
                                    authLog.setAuthDate(DateUtils.getNowDate());
                                    noPhotoList.add(authLog);
                                    continue;
                                }
                                try {
                                    String photoPath = authLog.getImgPath();
                                    photoPath = photoPath.replace("%2F", "/");
                                    String photoName = photoPath.substring(photoPath.lastIndexOf("/") + 1, photoPath.length());
                                    String fileName = this.idWorker.nextId() + photoName;
                                    File file = new File(BMSConfig.getTempPath() + fileName);
                                    photoPath = photoPath.startsWith("/obpm") ? this.configUtil.getV5URL().replace("/obpm", "") + photoPath : this.configUtil.getV5URL() + photoPath;
                                    logger.error("\u8eab\u4efd\u8bc1\uff1a{}\uff0c\u6bd4\u5bf9\u56fe\u7247\u5730\u5740\uff1a{}", (Object)authLog.getIdNumber(), (Object)photoPath);
                                    URL url = new URL(photoPath);
                                    FileUtils.copyURLToFile((URL)url, (File)file, (int)300000, (int)300000);
                                    long fileSize = FileUtil.size((File)file);
                                    if (!file.exists() || fileSize == 0L) {
                                        logger.error("\u8eab\u4efd\u8bc1\uff1a{}\uff0c\u6bd4\u5bf9\u7167\u7247\u4e0d\u5b58\u5728:{}", (Object)authLog.getIdNumber(), (Object)authLog.getImgPath());
                                        if (!file.exists()) {
                                            authLog.setAuthResult("\u6bd4\u5bf9\u7167\u7247\u4e0d\u5b58\u5728");
                                        } else {
                                            authLog.setAuthResult("\u4e0b\u8f7d\u5bf9\u6bd4\u7167\u7247\u5f02\u5e38");
                                        }
                                        authLog.setAuthStatus("1");
                                        authLog.setAuthDate(DateUtils.getNowDate());
                                        noPhotoList.add(authLog);
                                        continue;
                                    }
                                    filePaths.add(file.getAbsolutePath());
                                    authLog.setImgPath(file.getAbsolutePath());
                                    authList.add(authLog);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    logger.error("\u8eab\u4efd\u8bc1\uff1a{}\uff0c\u6bd4\u5bf9\u7167\u7247\u5f02\u5e38:{}", (Object)authLog.getIdNumber(), (Object)authLog.getImgPath());
                                    authLog.setAuthResult("\u6bd4\u5bf9\u7167\u7247\u5f02\u5e38|" + e.getMessage());
                                    authLog.setAuthStatus("1");
                                    if (authLog.getAuthResult().length() > 180) {
                                        authLog.setAuthResult(authLog.getAuthResult().substring(0, 180));
                                    }
                                    authLog.setAuthDate(DateUtils.getNowDate());
                                    noPhotoList.add(authLog);
                                }
                            }
                        });
                    }
                    finally {
                        if (noPhotoList.size() > 0) {
                            resultList.addAll(noPhotoList);
                        }
                    }
                }
            }
            try {
                if (CollectionUtils.isEmpty(authList)) {
                }
                List<AuthLog> limitAuthUsers = Collections.synchronizedList(new ArrayList());
                for (AuthLog authLog : authList) {
                    limitAuthUsers.add(authLog);
                    if (limitAuthUsers.size() != 30) continue;
                    try {
                        List<AuthLog> logList = null;
                        try {
                            logList = this.configUtil.isTest() ? this.comparisonTest(authList) : this.configUtil.getBackGroupService().validateResult(authList);
                            logger.error("\u8fd4\u56de\u7ed3\u679c\u6761\u6570\uff1a{}", (Object)(logList == null ? 0 : logList.size()));
                        }
                        catch (Throwable throwable) {
                            logger.error("\u8fd4\u56de\u7ed3\u679c\u6761\u6570\uff1a{}", (Object)(logList == null ? 0 : logList.size()));
                            if (logList == null) throw throwable;
                            if (logList.size() <= 0) throw throwable;
                            try {
                                resultList.addAll(logList);
                                throw throwable;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                logger.error("\u5b9e\u540d\u8ba4\u8bc1\u5f02\u5e38\uff1a{}", (Throwable)e);
                            }
                            throw throwable;
                        }
                        if (logList != null && logList.size() > 0) {
                            try {
                                resultList.addAll(logList);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                logger.error("\u5b9e\u540d\u8ba4\u8bc1\u5f02\u5e38\uff1a{}", (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u5b9e\u540d\u8ba4\u8bc1\u5f02\u5e38\uff1a{}", (Throwable)e);
                    }
                    limitAuthUsers = Collections.synchronizedList(new ArrayList());
                }
                if (limitAuthUsers.size() <= 0) {
                }
                try {
                    List<AuthLog> logList = null;
                    try {
                        logList = this.configUtil.isTest() ? this.comparisonTest(authList) : this.configUtil.getBackGroupService().validateResult(authList);
                        logger.error("\u8fd4\u56de\u7ed3\u679c\u6761\u6570\uff1a{}", (Object)(logList == null ? 0 : logList.size()));
                    }
                    catch (Throwable throwable) {
                        logger.error("\u8fd4\u56de\u7ed3\u679c\u6761\u6570\uff1a{}", (Object)(logList == null ? 0 : logList.size()));
                        if (logList == null) throw throwable;
                        if (logList.size() <= 0) throw throwable;
                        try {
                            resultList.addAll(logList);
                            throw throwable;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("\u5b9e\u540d\u8ba4\u8bc1\u5f02\u5e38\uff1a{}", (Throwable)e);
                        }
                        throw throwable;
                    }
                    if (logList != null) {
                        if (logList.size() <= 0) {
                        }
                        try {
                            resultList.addAll(logList);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("\u5b9e\u540d\u8ba4\u8bc1\u5f02\u5e38\uff1a{}", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u5b9e\u540d\u8ba4\u8bc1\u5f02\u5e38\uff1a{}", (Throwable)e);
                }
            }
            finally {
                if (filePaths.size() <= 0) return resultList;
                Iterator<String> iterator = filePaths.iterator();
                while (iterator.hasNext()) {
                    String filePath = iterator.next();
                    FileUtils.deleteFile((String)filePath);
                }
                return resultList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return resultList;
        }
        finally {
            logger.error("\u7ed3\u675f\u5b9e\u540d\u8ba4\u8bc1-----------------" + startDate + "--" + format.format(DateUtils.getNowDate()));
        }
    }

    private void splitAndExecuteAction(List<AuthLog> source, int pageSize, Consumer<List<AuthLog>> supplier) {
        ArrayList downloadAndCheckAuthLogs = new ArrayList();
        ArrayList<AuthLog> tmpCheckedAuthLogs = new ArrayList<AuthLog>();
        for (int i = 1; i < source.size() + 1; ++i) {
            tmpCheckedAuthLogs.add(source.get(i - 1));
            if (i == 0 || i % pageSize != 0) continue;
            downloadAndCheckAuthLogs.add(tmpCheckedAuthLogs);
            tmpCheckedAuthLogs = new ArrayList();
        }
        if (tmpCheckedAuthLogs.size() > 0) {
            downloadAndCheckAuthLogs.add(tmpCheckedAuthLogs);
            tmpCheckedAuthLogs = new ArrayList();
        }
        downloadAndCheckAuthLogs.parallelStream().forEach(list -> supplier.accept((List<AuthLog>)list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getFtpPhoto(String idNumber, String url) {
        int pos = url.indexOf("/uploads/");
        if (pos >= 0) {
            url = url.substring(pos);
        }
        Ftp ftp = null;
        String filePath = url.substring(0, url.lastIndexOf("/") + 1);
        String fileName = this.idWorker.nextId() + url.substring(url.lastIndexOf("/") + 1);
        File tempFile = new File(BMSConfig.getTempPath() + fileName);
        String path = (StrUtil.isEmpty((CharSequence)this.configUtil.getFilePath()) ? "" : this.configUtil.getFilePath()) + filePath;
        logger.error("1.ftp config={},{},{},{}", new Object[]{this.configUtil.getHost(), this.configUtil.getPort(), this.configUtil.getUserName(), this.configUtil.getPassword()});
        try {
            ftp = new Ftp(this.configUtil.getHost(), this.configUtil.getPort().intValue(), this.configUtil.getUserName(), this.configUtil.getPassword());
            ftp.setMode(FtpMode.Passive);
            ftp.download(path, fileName, tempFile);
            if (null == ftp) return tempFile;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                logger.error("\u83b7\u53d6" + idNumber + "+ftp\u56fe\u7247\u8def\u5f84" + filePath + "\u62a5\u9519\uff1a" + e);
                if (null == ftp) return tempFile;
            }
            catch (Throwable throwable) {
                if (null == ftp) throw throwable;
                IoUtil.close(ftp);
                throw throwable;
            }
            IoUtil.close((Closeable)ftp);
            return tempFile;
        }
        IoUtil.close((Closeable)ftp);
        return tempFile;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, MalformedURLException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        System.out.println(format.format(DateUtils.getNowDate()));
    }
}

