/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    Logger logger = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String remoteFilePath, String localFilePath) throws Exception {
        URL urlfile = null;
        HttpURLConnection httpUrl = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        File f = new File(localFilePath);
        try {
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            urlfile = new URL(remoteFilePath);
            httpUrl = (HttpURLConnection)urlfile.openConnection();
            httpUrl.connect();
            bis = new BufferedInputStream(httpUrl.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(f));
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = bis.read(b)) != -1) {
                ((BufferedOutputStream)bos).write(b, 0, len);
            }
            ((BufferedOutputStream)bos).flush();
            bis.close();
            httpUrl.disconnect();
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile1(String remoteFilePath, String localFilePath) throws Exception {
        HttpURLConnection connection = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            File targetFile = new File(localFilePath);
            File parentDir = targetFile.getParentFile();
            if (parentDir != null && !parentDir.exists()) {
                parentDir.mkdirs();
            }
            File tempFile = File.createTempFile("download_", ".tmp", parentDir);
            URL url = new URL(remoteFilePath);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Accept-Encoding", "identity");
            inputStream = connection.getInputStream();
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            long contentLength = connection.getContentLengthLong();
            if (contentLength > 0L && tempFile.length() != contentLength) {
                throw new IOException("\u4e0b\u8f7d\u6587\u4ef6\u4e0d\u5b8c\u6574: " + tempFile.length() + "/" + contentLength + " bytes");
            }
            Files.move(tempFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void downloadWithHttpClient(String url, String localPath) throws IOException {
        block36: {
            try (CloseableHttpClient client = HttpClients.createDefault();){
                HttpGet request = new HttpGet(url);
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                    HttpEntity entity = response.getEntity();
                    if (entity == null) break block36;
                    File target = new File(localPath);
                    try (InputStream in = entity.getContent();){
                        Files.copy(in, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
            }
        }
    }
}

