/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.auth.system.domain.PerCerDto;
import com.bcxin.auth.system.mapper.PerCerMapper;
import com.bcxin.auth.system.service.PerCerService;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerCerServiceImpl
implements PerCerService {
    private static Logger logger = LoggerFactory.getLogger(PerCerServiceImpl.class);
    @Autowired
    private PerCerMapper perCerMapper;

    @Override
    public int insert(PerCerDto perCerDto) {
        return this.perCerMapper.insertPerCer(perCerDto);
    }

    @Override
    public void update(PerCerDto perCerDto) {
        this.perCerMapper.updatePerCer(perCerDto);
    }

    @Override
    public void updatePrintState(PerCerDto perCerDto) {
        this.perCerMapper.updatePrintState(perCerDto);
    }

    @Override
    public void updateCallBackState(PerCerDto perCerDto) {
        this.perCerMapper.updateCallBackState(perCerDto);
    }

    @Override
    public void cancelPrint(PerCerDto perCerDto) {
        this.perCerMapper.cancelPrint(perCerDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generatePrintRecord(PerCerDto perCerDto) {
        HashMap params = Maps.newHashMap();
        params.put("id", perCerDto.getBusiness_id());
        params.put("printDate", perCerDto.getPrintDate());
        params.put("printOrganization", perCerDto.getPrint_organization());
        params.put("printPeople", perCerDto.getPrint_people());
        String returnValue = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(perCerDto.getCall_back_url());
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            StringEntity requestEntity = new StringEntity(JSON.toJSONString((Object)params), "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            System.out.println(requestEntity);
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("accessToken", perCerDto.getAccess_token());
            System.out.println(httpPost);
            httpPost.setConfig(requestConfig.build());
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    @Override
    public List<PerCerDto> findUnUploadRecord() {
        return this.perCerMapper.findUnUploadRecord();
    }

    @Override
    public PerCerDto findById(String id) {
        return this.perCerMapper.findById(id);
    }

    @Override
    public List<PerCerDto> findByIds(List<String> ids) {
        return this.perCerMapper.findByIds(ids);
    }
}

