package com.bcxin.obpm.util;



import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.obpm.dto.hunanAuth.SecurityMan;
import com.bcxin.obpm.dto.hunanAuth.ZhiNenRenShiReturn;

import java.util.HashMap;
import java.util.Map;


/**
 * author duxiangyun
 */
public class SRRZUtilEnding {

    //智能人事常量
    public static final String DATA_FROM = "43" ;
    public static final String AUTH_TOKEN = "Bearer eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsInVzZXJuYW1lIjoiMDAwbU96b3IifQ.12P7HSnh112iOjj769ITV51jN5QB5qFPvmE12N60kgs";
    //正式环境
    public static final String AUTH_IMG = "https://v5qy.baibaodun.cn/obpm" ;
    public static final String GET_AUTH_DATA_URL = "https://v5qy.baibaodun.cn/v3/tenant/users/get-user/region";
    public static final String UPDATE_AUTH_DATA_URL = "https://v5qy.baibaodun.cn/v3/tenant/users/update-user/real-name";

    //实人认证的地址
    public static final String AUTH_URL="https://fwpt.hnga.gov.cn/interface_api/interface/public/call";
    //实人认证接口的参数
    private static final int MODE = 66;
    private static final String FSD="430000";
    private static final String SBM = "湖南省公安厅";
    private static final String YWLX = "湖南省公安厅服务平台身份认证";
    private static final String CODE = "DI-10000117";   //接口编号
    private static final String U_CODE = "10000027";    //用户编号
    private static final int S_Y_Z_D= 0 ;
    //数据加密密钥 - 公钥
    private static final String SIGNATURE_PUBLIC_KEY =  "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCPoFYbdH5EM32OGnFfpvZvqISh4Z10QJVT9KOGhZL1e/eLXftCNNtGA7JKiRckD4pOav9rkUoluGUrAOySJdp8TNVCMPpjdvbAfSVVS6qLPprpJMuBO+FCxtkHRQBhknUuJZpN/JDnevHTYtfnN10LM5xQgJvYZSj0PdPKt6n5GQIDAQAB";
    private static final String DATA_PUBLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCr/cDe+yooypVY17Q3J4sVXIBnQNpngQQbLnZNQG+riP3L49ialmOTMY7MAIdum0ZpsulGIauMlZoDWRyBm4b9OKbcLEDayglUdc7mEm6r6oLFopn34g7BWFj6ckSm8HJY/6MQrtJjPRvSsfw5zDul2vJTtm4VHo8hbHLkKLytfwIDAQAB";

    /**
     * description 封装调用实人认证的参数
     * @param securityMan
     * @param imageBase
     * @return
     * @throws Exception
     */
    public static String authUtil(SecurityMan securityMan, String imageBase) {
        Map<String,Object> map=new HashMap<>();
        Map<String,Object> idInfo=new HashMap<>();
        Map<String,Object> businessExtraInfo=new HashMap<>();
        Map<String,Object> authData=new HashMap<>();
        map.put("mode",MODE);
        map.put("portrait",imageBase);
        idInfo.put("idNum",securityMan.getNumber());
        idInfo.put("fullName",securityMan.getName());
        businessExtraInfo.put("fsd",FSD);
        businessExtraInfo.put("sbm",SBM);
        businessExtraInfo.put("ywlx",YWLX);
        businessExtraInfo.put("syzd",S_Y_Z_D);
        map.put("idInfo",idInfo);
        authData.put("businessExtraInfo",businessExtraInfo);
        authData.put("authData",map);
        // 请求参数
        String arg = JSONObject.toJSONString(authData);
        // 签名规则
        String signature = U_CODE + "*" + System.currentTimeMillis();
        // 签名加密
        String signatureSecurity = null;
        try {
            signatureSecurity = RSAUtil.encrypt(signature, SIGNATURE_PUBLIC_KEY);
            // 组合 data的参数 示例使用是alibaba.fastjson
            JSONObject json = new JSONObject();
            json.put("code", CODE);  // 接口编号
            json.put("args", arg);   // 请求参数
            String data = json.toJSONString();
            // 对data进行加密
            String dataSecurity = RSAUtil.encrypt(data, DATA_PUBLIC_KEY);
            // 组合所有参数，转化为json字符串
            JSONObject jsonRes = new JSONObject();
            jsonRes.put("signature", signatureSecurity);
            jsonRes.put("data", dataSecurity);
            jsonRes.put("ucode", U_CODE);
            return jsonRes.toJSONString();
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }
    //解析调用智能人事取数据的报文
    public static ZhiNenRenShiReturn parseAuthData(String getDtaJson){
        JSONObject jsonObject = JSON.parseObject(getDtaJson);
        ZhiNenRenShiReturn zhiNenRenShiReturn = jsonObject.toJavaObject(ZhiNenRenShiReturn.class);
//        ZhiNenRenShiReturn zhiNenRenShi = JSON.toJavaObject(jsonObject, ZhiNenRenShiReturn.class);
        return zhiNenRenShiReturn;
    }

    public static String imgPathHandle(String imgPath){
        String imageAbsolutePath =null;
        if (StrUtil.isNotBlank(imgPath)){
            if (imgPath.startsWith("https")){
                imageAbsolutePath = imgPath;
            }else {
                imageAbsolutePath = AUTH_IMG + imgPath;
            }
        }
        return imageAbsolutePath;
    }



}
