package com.bcxin.obpm.schedule;

import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.file.FileUtils;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.mapper.TenantUserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/**
 * @Auther linqinglin
 * @date 2021/4/28 21:49
 */
@Component("photoDataSyncTask")
public class PhotoDataSyncTask {

    private static Logger logger = LoggerFactory.getLogger(PhotoDataSyncTask.class);

    @Autowired
    ISysConfigService configService;

    @Autowired
    ConfigUtil configUtil;

    @Autowired
    TenantUserMapper tenantUserMapper;

    private boolean lock = false;

    public void run(){
        if(lock){
            return;
        }
        lock = true;

        try {
            if(!configUtil.isIntranet()){
                List<AuthLog>  photoList = tenantUserMapper.queryPhotos(null);
                List<String> filePaths = new ArrayList<>();
                if(photoList.size() > 0) {
                    for (AuthLog authLog : photoList) {
                        String fileName = configUtil.getDemoPath() + authLog.getImgPath();
                        filePaths.add(fileName);
                    }

                    if(filePaths.size() > 0) {
                        String fileName = BMSConfig.getTempPath() + "Photo_" + DateUtils.dateTimeNow(DateUtils.YYYYMMDDHHMMSS) + Constants.ZIP;
                        //生成同步数据文件压缩包
                        FileUtils.zipFiles(filePaths, fileName);
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
        }finally {
            lock = false;
        }
    }
    public void runForProvinceName(String provinceName){
        if(lock){
            return;
        }
        lock = true;

        try {
            if(!configUtil.isIntranet()){
                List<AuthLog>  photoList = tenantUserMapper.queryPhotos(provinceName);
                List<String> filePaths = new ArrayList<>();
                if(photoList.size() > 0) {
                    for (AuthLog authLog : photoList) {
                        String fileName = configUtil.getDemoPath() + authLog.getImgPath();
                        filePaths.add(fileName);
                    }

                    if(filePaths.size() > 0) {
                        String fileName = BMSConfig.getTempPath() + "Photo_" + DateUtils.dateTimeNow(DateUtils.YYYYMMDDHHMMSS) + Constants.ZIP;
                        //生成同步数据文件压缩包
                        FileUtils.zipFiles(filePaths, fileName);
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            logger.error(e.getMessage());
        }finally {
            lock = false;
        }
    }

    public static void main(String[] args) throws Exception {

        String fileName = "/uploads/lib/img/142.png";
        fileName = fileName.substring(fileName.lastIndexOf("/"));
        String extendName = fileName.substring(fileName.lastIndexOf("."));
        File file = new File("d:/auth/temp/"+DateUtils.dateTimeNow(DateUtils.YYYY_MM_DD)+fileName);
        URL url = new URL("http://v5qy.baibaodun.cn/signon/uploads/lib/img/142.png");
        FileUtils.copyURLToFile(url,file,30000,30000);

        System.out.println(file.getAbsolutePath());

    }

}
