package com.bcxin.obpm.schedule;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.domain.MinisterialLog;
import com.bcxin.obpm.dto.Ministerial.MinisterialDataType;
import com.bcxin.obpm.dto.Ministerial.XxbaBaseDto;
import com.bcxin.obpm.dto.MinisterialAjaxResult;
import com.bcxin.obpm.service.MinisterialLogService;
import com.bcxin.obpm.util.MinisterialUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 数据定时上报部级接口
 * @author linqinglin
 * @date 2021/03/04 0004 14:36
 */
@Service
public class MinisterialAutoTask {

    /**
     * 日志对象
     */
    protected Logger logger = LoggerFactory.getLogger(getClass());


    @Autowired
    private MinisterialLogService ministerialLogService;

    @Autowired
    private MinisterialUtil ministerialUtil;

    @Autowired
    private ConfigUtil configUtils;

    @Autowired
    private ISysConfigService configService;

    private boolean lock = false;

    public void run(){
        if(lock){
            return;
        }
        lock = true;
        try{
            if (configUtils.isIntranet()) {
                syncRun();
            }
        }catch (Exception e){

        }finally {
            lock = false;
        }
    }

    private void syncRun(){
        String ministerial_limit = configService.selectConfigByKey(Constants.MINISTERIAL_LIMIT);
        int limit = 3;
        try{
            limit = Integer.parseInt(ministerial_limit);
        }catch (Exception e){

        }
        for (MinisterialDataType dataType : MinisterialDataType.values()) {
            try {
                List<Map> list = ministerialLogService.getBusinessDatas(dataType,limit);
                if(list == null || list.size() < 1){
                    //无值
                    continue;
                }
                //System.out.println(JSONArray.toJSONString(list));
                List dataList = JSONArray.parseArray(JSONArray.toJSONString(list),dataType.getDataClazz());
                for (Object o : dataList) {
                    try {
                        MinisterialAjaxResult result = ministerialUtil.send(dataType, o);
                        logger.error("部级上报日志结果："+result.toString());
                        if(result.isSuccessful()) {
                            MinisterialLog log = new MinisterialLog();
                            log.setBusinessType(dataType.getCode());
                            if (result.getData() != null) {
                                log.setSerialNo(result.getData().toString());
                            }
                            log.setState("1");
                            log.setActive(true);
                            log.setCreateTime(new Date());
                            log.setUpdateTime(new Date());
                            log.setBusinessId(((XxbaBaseDto)o).getId());
                            logger.error("开始添加日志"+log);
                            ministerialLogService.save(log);
                            logger.error("结束添加日志");
                        }
                        Thread.sleep(1000);
                    }catch (Exception e){
                        logger.error(e.getMessage(),e);
                        e.printStackTrace();
                    }
                }
                Thread.sleep(3000);
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
                e.printStackTrace();
            } finally {
            }
        }

    }

}
