package com.bcxin.obpm.schedule;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.Ftp;
import cn.hutool.extra.ftp.FtpMode;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpStatus;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.*;
import com.bcxin.auth.common.utils.file.FileUtils;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.dto.PhotoDto;
import com.bcxin.obpm.service.IObpmSecurityManService;
import com.bcxin.obpm.util.AuthConstants;
import net.sf.ehcache.util.PropertyUtil;
import org.apache.shiro.codec.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.servlet.ServletOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * @Auther linqinglin
 * @date 2021/4/28 21:49
 */
@Component("authTask")
public class AuthTask {

    private static Logger logger = LoggerFactory.getLogger(AuthTask.class);

    @Autowired
    ISysConfigService configService;

    @Autowired
    ConfigUtil configUtil;

    @Autowired
    IObpmSecurityManService obpmSecurityManService;

    @Resource
    IdWorker idWorker;


    private List<AuthLog> comparisonTest(List<AuthLog> list) {
        for (AuthLog authLog : list) {
            String num = authLog.getIdNumber().substring(authLog.getIdNumber().length() - 1);
            if (num.equals("4") || num.equals("5") || num.equals("6") || num.equals("7") || num.equals("8")) {
                authLog.setAuthStatus(AuthConstants.AUTHRESULT_YES);
                authLog.setAuthResult("测试--认证通过");
            } else {
                authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                authLog.setAuthResult("测试--" + AuthConstants.AUTHRESULT_NO_NAME_IDEMSG);
            }
            authLog.setAuthDate(new Date());
        }
        return list;
    }


    public List<AuthLog> validateResult(List<AuthLog> allAuthLogs) {

        SimpleDateFormat format=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        String startDate=format.format(DateUtils.getNowDate());
        List<AuthLog> noPhotoList = Collections.synchronizedList(new ArrayList<>());
        List<AuthLog> resultList =  Collections.synchronizedList(new ArrayList<>());
        try {
            if (configUtil.isIntranet()) {
                logger.error("开始实名认证-----------------" +startDate);
                logger.error("待认证数据" + allAuthLogs.size());
                List<AuthLog> authList = Collections.synchronizedList(new ArrayList<>());
                List<String> filePaths = Collections.synchronizedList(new ArrayList<>());

                if (!CollectionUtils.isEmpty(allAuthLogs)) {
                    if (configUtil.isTest()) {
                        authList.addAll(allAuthLogs);
                    } else {
                        try{
                            this.splitAndExecuteAction(allAuthLogs, 100, list -> {
                                for (AuthLog authLog : allAuthLogs) {
                                    /***2.0判断身份证是否符合规范******/
                                    if (!IdcardUtils.validateCard(authLog.getIdNumber())){
                                        logger.error("身份证号不符合规范,认证失败:{}", authLog.getIdNumber());
                                        authLog.setAuthResult("身份证号不符合规范,认证失败");
                                        authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                                        authLog.setAuthDate(DateUtils.getNowDate());
                                        noPhotoList.add(authLog);
                                        continue;
                                    }
                                    /***2.1判断照片是否存在******/
                                    if (StringUtils.isEmpty(authLog.getImgPath())) {
                                        logger.error("一寸照片为空，认证失败:{}", authLog.getIdNumber());
                                        authLog.setAuthResult("未上传一寸照，认证失败");
                                        authLog.setAuthStatus(AuthConstants.AUTHRESULT_NO);
                                        authLog.setAuthDate(DateUtils.getNowDate());
                                        noPhotoList.add(authLog);
                                        continue;
                                    }
                                    try {
                                        String photoPath=authLog.getImgPath();
                                        photoPath=photoPath.replace("%2F","/");
                                        String photoName = photoPath.substring(photoPath.lastIndexOf("/")+1,
                                                photoPath.length());
                                        String fileName = idWorker.nextId()+photoName;
                                        File file = new File(BMSConfig.getTempPath() + fileName);
                                        if (photoPath.startsWith("/obpm")){
                                            photoPath=configUtil.getV5URL().replace("/obpm","")+photoPath;
                                        }else {
                                            photoPath=configUtil.getV5URL() +photoPath;
                                        }
                                        logger.error("身份证：{}，比对图片地址：{}", authLog.getIdNumber(), photoPath);
                                        URL url = new URL(photoPath);
                                        FileUtils.copyURLToFile(url, file, 300000, 300000);
                                        long fileSize= FileUtil.size(file);
                                        if (!file.exists() || fileSize==0) {
                                            logger.error("身份证：{}，比对照片不存在:{}", authLog.getIdNumber(), authLog.getImgPath());
                                            if(!file.exists()) {
                                                authLog.setAuthResult("比对照片不存在");
                                            }else {
                                                authLog.setAuthResult("下载对比照片异常");
                                            }
                                            authLog.setAuthStatus(AuthConstants.AUTHRESULT_ZHONG);
                                            authLog.setAuthDate(DateUtils.getNowDate());
                                            noPhotoList.add(authLog);
                                            continue;
                                        }

                                        filePaths.add(file.getAbsolutePath());
                                        authLog.setImgPath(file.getAbsolutePath());
                                        authList.add(authLog);
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                        logger.error("身份证：{}，比对照片异常:{}", authLog.getIdNumber(), authLog.getImgPath());
                                        authLog.setAuthResult("比对照片异常|" + e.getMessage());
                                        authLog.setAuthStatus(AuthConstants.AUTHRESULT_ZHONG);
                                        if(authLog.getAuthResult().length()>180) {
                                            authLog.setAuthResult(authLog.getAuthResult().substring(0, 180));
                                        }

                                        authLog.setAuthDate(DateUtils.getNowDate());
                                        noPhotoList.add(authLog);
                                        continue;
                                    }
                                }
                            });
                        }finally {
                            if (noPhotoList.size() > 0) {
                                resultList.addAll(noPhotoList);
                            }
                        }
                    }
                }
                try {
                    if (!CollectionUtils.isEmpty(authList)) {
                        List<AuthLog> limitAuthUsers = Collections.synchronizedList(new ArrayList<>());
                        for (AuthLog authLog :authList){
                            limitAuthUsers.add(authLog);
                            if (limitAuthUsers.size()==30){
                                try {
                                    List<AuthLog> logList = null;
                                    try {
                                        if (configUtil.isTest()) {
                                            logList = comparisonTest(authList);
                                        } else {
                                            logList = configUtil.getBackGroupService().validateResult(authList);
                                        }
                                    } finally {
                                        logger.error("返回结果条数：{}", logList == null ? 0 : logList.size());
                                        if (logList != null && logList.size() > 0) {
                                            try {
                                                resultList.addAll(logList);
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                                logger.error("实名认证异常：{}", e);
                                            }
                                        }
                                    }
                                } catch (Exception e) {
                                    logger.error("实名认证异常：{}", e);
                                }
                                limitAuthUsers = Collections.synchronizedList(new ArrayList<>());
                            }
                        }
                        if (limitAuthUsers.size()>0) {
                            try {
                                List<AuthLog> logList = null;
                                try {
                                    if (configUtil.isTest()) {
                                        logList = comparisonTest(authList);
                                    } else {
                                        logList = configUtil.getBackGroupService().validateResult(authList);
                                    }
                                } finally {
                                    logger.error("返回结果条数：{}", logList == null ? 0 : logList.size());
                                    if (logList != null && logList.size() > 0) {
                                        try {
                                            resultList.addAll(logList);
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            logger.error("实名认证异常：{}", e);
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                logger.error("实名认证异常：{}", e);
                            }
                        }
                    }
                }finally {
                    if (filePaths.size() > 0) {
                        for (String filePath : filePaths) {
                            FileUtils.deleteFile(filePath);
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        } finally {
            logger.error("结束实名认证-----------------"+startDate+"--"+format.format(DateUtils.getNowDate()));
        }
        return resultList;
    }

    private void splitAndExecuteAction(List<AuthLog> source, int pageSize, Consumer<List<AuthLog>> supplier) {
        Collection<List<AuthLog>> downloadAndCheckAuthLogs = new ArrayList<>();
        List<AuthLog> tmpCheckedAuthLogs = new ArrayList<>();
        for (int i = 1; i < source.size() + 1; i++) {
            tmpCheckedAuthLogs.add(source.get(i - 1));
            if (i != 0 && (i % pageSize) == 0) {
                downloadAndCheckAuthLogs.add(tmpCheckedAuthLogs);
                tmpCheckedAuthLogs = new ArrayList<>();
            }
        }

        if (tmpCheckedAuthLogs.size() > 0) {
            downloadAndCheckAuthLogs.add(tmpCheckedAuthLogs);
            tmpCheckedAuthLogs = new ArrayList<>();
        }

        downloadAndCheckAuthLogs.parallelStream().forEach(list -> {
            supplier.accept(list);
        });
    }

    public File getFtpPhoto(String idNumber, String url) {
        int pos = url.indexOf("/uploads/");
        if (pos >= 0) {
            url = url.substring(pos);
        }
        Ftp ftp = null;

        // 文件路径
        String filePath = url.substring(0, url.lastIndexOf("/") + 1);
        // 文件名称
        String fileName = idWorker.nextId() + url.substring(url.lastIndexOf("/") + 1);
        File tempFile = new File(BMSConfig.getTempPath() + fileName);
        String path = (StrUtil.isEmpty(configUtil.getFilePath()) ? "" : configUtil.getFilePath()) + filePath;
        logger.error("1.ftp config={},{},{},{}", configUtil.getHost(), configUtil.getPort(), configUtil.getUserName(), configUtil.getPassword());
        try {
            ftp = new Ftp(configUtil.getHost(), configUtil.getPort(), configUtil.getUserName(), configUtil.getPassword());
            ftp.setMode(FtpMode.Passive);
            ftp.download(path, fileName, tempFile);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("获取" + idNumber + "+ftp图片路径" + filePath + "报错：" + e);
        } finally {
            if (null != ftp) {
                IoUtil.close(ftp);
            }
        }
        return tempFile;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, MalformedURLException {
        //String json ="[{\"name\":\"upload0.08969473242659509.png\",\"originalPath\":\"http://119.3.247.211/obpm/v2/sync/file/download?f=%2Fuploads%2Flib%2Fimg%2Fupload0.08969473242659509.png\",\"path\":\"/uploads/lib/img/upload0.08969473242659509.png\"}]";
        //
        //List<PhotoDto> photoDtos = JSONArray.parseArray(json, PhotoDto.class);
        //PhotoDto photoDto = photoDtos.get(0);
        //    System.out.println(photoDto.getName());
        //    System.out.println(photoDto.getPath());
        /*File file = new File("D:/.temp/2022-01-02/" + "image.jpg");
        URL url = new URL("http://v5inmy.test.baibaodun.cn/obpm/uploads/2021/image.jpg");
        try {
            FileUtils.copyURLToFile(url, file, 30000, 30000);
        } catch (IOException e) {
            e.printStackTrace();
        }*/
        /*KeyGenerator keygen = KeyGenerator.getInstance("AES");
        SecretKey deskey = keygen.generateKey();
        System.out.println(Base64.encodeToString(deskey.getEncoded()));*/

/*
        String photoPath="https://bcxin-saas-prod.obs.cn-north-1.myhuaweicloud.com/upload%2F2022-05-16%2F1652698873749826838.jpg";
        photoPath=photoPath.replace("%2F","/");
        String  photoName=photoPath.substring(photoPath.lastIndexOf("/")+1,
                photoPath.length());
        System.out.println(photoName);*/
        SimpleDateFormat format=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        System.out.println(format.format(DateUtils.getNowDate()));


    }
}
