package com.bcxin.obpm.ministerial;

import com.bcxin.obpm.annotation.MinisterialAttr;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.math.BigDecimal;

/**
 * 万元金额转元
 * @author linqinglin
 * @date 2021/03/09 0009 16:17
 */
@Component
public class AmountFormatStrategy implements MinDataFormatStrategy {
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        String yuan = (String) data;
        if (yuan != null) {
            BigDecimal bigDecimal = new BigDecimal(yuan);
            bigDecimal=bigDecimal.multiply(BigDecimal.valueOf(10000));
            return String.valueOf(bigDecimal.setScale(4,BigDecimal.ROUND_HALF_UP));
        }
        return null;

    }

    public static void main(String[] args) {
        Object data = "0";
        System.out.println(new BigDecimal(data.toString()).multiply(BigDecimal.valueOf(10000L)).toString());
    }
}
