package com.bcxin.obpm.dto;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;

@Data
public class MinisterialAjaxResult implements Serializable {

	private static final long serialVersionUID = 4530474987109938356L;
	
	private boolean successful;
	private String code;
	private String msg;
	private Object data;
	private Object obj;

	/**
	 * token 用做表单重复提交验证
	 */
	private String token;

	public MinisterialAjaxResult(){

	}

	public MinisterialAjaxResult(boolean successful, String msg){
		this.successful = successful;
		this.msg = msg;
	}

	public MinisterialAjaxResult(boolean successful, String msg, Object data){
		this.successful = successful;
		this.msg = msg;
		this.data = data;
	}

	/**
	 * 广西公安互联网验证状态码
	 */
	private Integer state;

	public static String unLogin() {
		MinisterialAjaxResult result = new MinisterialAjaxResult();
		result.setCode("0000");
		result.setMsg("登录超时，请重新登录！");
		result.setSuccessful(false);
		return JSON.toJSONString(result);
	}

	public static MinisterialAjaxResult error(String msg) {
		MinisterialAjaxResult result = new MinisterialAjaxResult();
		result.setCode("0");
		result.setMsg(msg);
		result.setSuccessful(false);
		return result;
	}

	public static MinisterialAjaxResult success(String msg, Object data) {
		MinisterialAjaxResult result = new MinisterialAjaxResult();
		result.setCode("1");
		result.setMsg(msg);
		result.setSuccessful(true);
		result.setData(data);
		return result;
	}
}
