package com.bcxin.obpm.dto.Ministerial;

import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.annotation.MinisterialEntity;
import lombok.Data;

/**
 * 表彰奖励情况基本信息
 *
 * @author llc
 */
@Data
@MinisterialEntity(tableName = "v_company_award")
public class Babzjl extends XxbaBaseDto {


    /**
     * 被表彰奖励对象编码
     */

    @MinisterialAttr(column = "(select item_companyCode from tlk_companyinformation sc where sc.DOMAINID = t1.DOMAINID and sc.ITEM_companyName=t1.ITEM_COMPANYNAME limit 1)", isSubQuery = true)
    private String bjldxbm;
    /**
     * 被表彰奖励对象类别
     * 1：保安服务公司；
     * 2：自行招用保安员的单位；
     * 3：保安培训机构；
     * 4：保安员
     */
    @MinisterialAttr(column = "bjldxlb")
    private String bjldxlb;
    /**
     * 表彰奖励事迹
     */
    @MinisterialAttr(column = "ITEM_COMMENDATIONREWARDREASON")
    private String jlsj;
    /**
     * 表彰奖励形式
     */
    @MinisterialAttr(column = "ITEM_COMMENDATIONREWARDCONTENT")
    private String jlxs;
    /**
     * 表彰奖励级别
     */
    private String jljb;
    /**
     * 表彰奖励日期
     */
    @MinisterialAttr(column = "ITEM_COMMENDATIONREWARDTIME",DATE_FORMAT = "%Y%m%d")
    private String jlrq;
    /**
     * 表彰奖励单位名称
     */
    @MinisterialAttr(column = "ITEM_COMPANYNAME")
    private String jldwmc;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;


    @Override
    public String toString() {
        return "Babzjl{" +
                "bjldxbm='" + bjldxbm + '\'' +
                ", bjldxlb='" + bjldxlb + '\'' +
                ", jlsj='" + jlsj + '\'' +
                ", jlxs='" + jlxs + '\'' +
                ", jljb='" + jljb + '\'' +
                ", jlrq='" + jlrq + '\'' +
                ", jldwmc='" + jldwmc + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                '}';
    }
}
