package com.bcxin.platform.common.constant;

/**
 * 码表常量库
 */

public class DictConst {

    /************ 当事人类型 ************/
    public final static String PARTYTYPE_QY = "1"; // 企业
    public final static String PARTYTYPE_RY = "2"; // 人员

    /************ 人口库类型 ************/
    public final static String PERSON_HEADIMG_Y = "3"; // 企业
    public final static String PERSON_HEADIMG_N = "2"; // 人员

    /************ 最后一次审核动作 ************/
    public final static String LASTAPPROVALFLAG_SPTG = "1"; // 审批通过
    public final static String LASTAPPROVALFLAG_SHBTG = "2"; // 审核不通过
    public final static String LASTAPPROVALFLAG_DH = "0"; // 打回

    /************ 业务办理状态 ************/
    public final static String BUSINESSHANDLSTATUS_SHTG = "1"; // 审核通过
    public final static String BUSINESSHANDLSTATUS_SHBTG = "2"; // 审核不通过
    public final static String BUSINESSHANDLSTATUS_DH = "0"; // 打回

    /************ 血型 ************/
    public final static String BLOODTYPE_A = "A"; // A
    public final static String BLOODTYPE_B = "B"; // B
    public final static String BLOODTYPE_O = "O"; // O
    public final static String BLOODTYPE_AB = "AB"; // AB

    /************ 政治面貌 ************/
    public final static String POLITICALSTATUS_ZGDY = "01"; // 中共党员
    public final static String POLITICALSTATUS_ZGYBDY = "02"; // 中共预备党员
    public final static String POLITICALSTATUS_GQTY = "03"; // 共青团员
    public final static String POLITICALSTATUS_MGHY = "04"; // 民革会员
    public final static String POLITICALSTATUS_MMMY = "05"; // 民盟盟员
    public final static String POLITICALSTATUS_MJIANHY = "06"; // 民建会员
    public final static String POLITICALSTATUS_MJINHY = "07"; // 民进会员
    public final static String POLITICALSTATUS_NGDDY = "08"; // 农工党党员
    public final static String POLITICALSTATUS_ZGDDY = "09"; // 致公党党员
    public final static String POLITICALSTATUS_JSXSSY = "10"; // 九三学社社员
    public final static String POLITICALSTATUS_TMMY = "11"; // 台盟盟员
    public final static String POLITICALSTATUS_WDPMZRS = "12"; // 无党派民主人士
    public final static String POLITICALSTATUS_QZ = "13"; // 群众

    /************ 婚姻状况 ************/
    public final static String MARITALSTATUS_WH = "1"; // 未婚
    public final static String MARITALSTATUS_YH = "2"; // 已婚
    public final static String MARITALSTATUS_SO = "3"; // 丧偶
    public final static String MARITALSTATUS_LH = "4"; // 离婚
    public final static String MARITALSTATUS_QT = "9"; // 其他

    /************ 沟通前状态 ************/
    public final static String COMMUNICATEPRESTATUS_WRJT = "1"; // 无人接听
    public final static String COMMUNICATEPRESTATUS_TJ = "2"; // 停机

    /************ 沟通中状态 ************/
    public final static String COMMUNICATESTATUS_DFTDHH = "1"; // 对方态度很好
    public final static String COMMUNICATESTATUS_DFTDEL = "2"; // 对方态度恶劣
    public final static String COMMUNICATEAFTERSTATUS_DFKL = "1"; // 对方考虑

    /************ 沟通后状态 ************/
    public final static String COMMUNICATEAFTERSTATUS_MSSJCT = "2"; // 面试时间冲突
    public final static String COMMUNICATEAFTERSTATUS_DFYZDGZ = "3"; // 对方已找到工作
    public final static String COMMUNICATEAFTERSTATUS_DFTYMS = "4"; // 对方同意面试

    /************ 同意面试后状态 ************/
    public final static String AGREEINTERVIEWSTATUS_MLCJMS = "1"; // 没来参加面试
    public final static String AGREEINTERVIEWSTATUS_BSH = "2"; // 不适合
    public final static String AGREEINTERVIEWSTATUS_XD = "3"; // 选定
    public final static String AGREEINTERVIEWSTATUS_YMS = "4"; // 已面试

    /************ 经历类别 ************/
    public final static String EXPERIENCETYPE_JYJL = "01"; // 教育经历
    public final static String EXPERIENCETYPE_PXJL = "02"; // 培训经历
    public final static String EXPERIENCETYPE_GZJL = "03"; // 工作经历
    public final static String EXPERIENCETYPE_SXJL = "04"; // 实习经历

    /************ 企业来源 ************/
    public final static String COMSOURCE_GADR = "1"; // 公安导入
    public final static String COMSOURCE_ZZZC = "2"; // 自主注册
    public final static String COMSOURCE_YQMTJ = "3"; // 邀请码推荐
    public final static String COMSOURCE_QT = "9"; // 其他

    /************ 消息范围 ************/
    public final static String NEWSSCOPE_GAXX = "1"; // 公安消息
    public final static String NEWSSCOPE_PTXX = "2"; // 平台消息
    public final static String NEWSSCOPE_QYXX = "3"; // 企业消息

    /************ 消息类型 ************/
    public final static String NEWSTYPE_XTTZ = "1"; // 系统通知
    public final static String NEWSTYPE_RWTZ = "2"; // 任务通知
    public final static String NEWSTYPE_KSTZ = "3"; // 考试通知
    public final static String NEWSTYPE_QYXX = "4"; // 企业消息

    /************ 发送人类型 ************/
    public final static String SENDERTYPE_QB = "1"; // 全部
    public final static String SENDERTYPE_XT = "2"; // 系统
    public final static String SENDERTYPE_GA = "3"; // 公安
    public final static String SENDERTYPE_QY = "4"; // 企业

    /************ 发送类型 ************/
    public final static String SENDWAY_SMS = "1"; // 短信
    public final static String SENDWAY_EMAIL = "2"; // 邮件
    public final static String SENDWAY_APP = "3"; // app

    /************ 人员证书等级 ************/
    public final static String PERCERLEVEL_CJBAY = "01000101"; // 初级保安员
    public final static String PERCERLEVEL_ZJBAY = "01000102"; // 中级保安员
    public final static String PERCERLEVEL_GJBAY = "01000103"; // 高级保安员
    public final static String PERCERLEVEL_BAS = "01000104"; // 保安师
    public final static String PERCERLEVEL_GJBAGLY = "01000105"; // 高级保安管理员

    /************ 考勤类型 ************/
    public final static String ATTENDTYPE_GDBZ = "1"; // 固定班制
    public final static String ATTENDTYPE_PBZ = "2"; // 排班制
    public final static String ATTENDTYPE_ZYGS = "3"; // 自由工时

    /************ 任务性质 ************/
    public final static String TASKNATURE_GD = "1"; // 固定
    public final static String TASKNATURE_LS = "2"; // 临时

    /************ 紧急程度 ************/
    public final static String URGENTLEVEL_PT = "1"; // 普通
    public final static String URGENTLEVEL_JJ = "2"; // 紧急

    /************ 任务状态 ************/
    public final static String TASKSTATUS_WKS = "0"; // 未开始
    public final static String TASKSTATUS_JXZ = "1"; // 进行中
    public final static String TASKSTATUS_YWC = "2"; // 已完成
    public final static String TASKSTATUS_YYQ = "3"; // 已延期
    public final static String TASKSTATUS_YQX = "4"; // 已取消
    public final static String TASKSTATUS_YZT = "5"; // 已暂停
    public final static String TASKSTATUS_WFB = "6"; // 未发布
    public final static String TASKSTATUS_YJS = "7"; // 已结束

    /************ 任务等级 ************/
    public final static String TASKLEVEL_QYJ = "1"; // 企业级
    public final static String TASKLEVEL_SQJ = "2"; // 社区级
    public final static String TASKLEVEL_QXJ = "3"; // 区县级
    public final static String TASKLEVEL_SHIJ = "4"; // 市级
    public final static String TASKLEVEL_SJ = "5"; // 省级
    public final static String TASKLEVEL_GJIAJ = "6"; // 国家级
    public final static String TASKLEVEL_GJIJ = "7"; // 国际级

    /************ 外勤排班方式子类型 ************/
    public final static String ATTENDSUBTYPE_ZQ = "1"; // 周期排班
    public final static String ATTENDSUBTYPE_SD = "2"; // 手动排班

    /************ 任务归属 ************/
    public final static String TASKASSIGN_WQ = "1"; // 外勤
    public final static String TASKASSIGN_RW = "2"; // 任务

    /************ 任务时间维度 ************/
    public final static String TASKTIMEDIMENSION_YGY = "1"; // 一个月
    public final static String TASKTIMEDIMENSION_SGY = "2"; // 三个月
    public final static String TASKTIMEDIMENSION_BN = "3"; // 半年
    public final static String TASKTIMEDIMENSION_YN = "4"; // 一年
    public final static String TASKTIMEDIMENSION_YJ = "5"; // 永久

    /************ 推送范围 ************/
    public final static String PUSHRANGE_NBTS = "1"; // 内部推送
    public final static String PUSHRANGE_QWTS = "2"; // 全网推送

    /************ 内部推送人员类别 ************/
    public final static String PUSHPERTYPE_CYRY = "1"; // 参与人员
    public final static String PUSHPERTYPE_CSRY = "2"; // 抄送人员

    /************ 任务人员投保方式 ************/
    public final static String TASKPERINSMODE_GRGM = "1"; // 个人购买
    public final static String TASKPERINSMODE_QYZSBX = "2"; // 企业赠送保险
    public final static String TASKPERINSMODE_WXTB = "9"; // 无需投保

    /************ 任务操作对象 ************/
    public final static String TASKOPEROBJECT_RW = "1"; // 任务
    public final static String TASKOPEROBJECT_SP = "2"; // 审批
    public final static String TASKOPEROBJECT_SQ = "3"; // 申请
    public final static String TASKOPEROBJECT_XM = "4"; // 项目
    public final static String TASKOPEROBJECT_HT = "5"; // 合同

    /************ 任务操作结果 ************/
    public final static String TASKOPERRESULT_DZLRYPB = "10"; // 调整了人员排班
    public final static String TASKOPERRESULT_TGSP = "20"; // 通过审批
    public final static String TASKOPERRESULT_TJLDBSQ = "30"; // 提交了调班申请
    public final static String TASKOPERRESULT_YLLGLXM = "40"; // 预览了关联项目
    public final static String TASKOPERRESULT_CYLGLHT = "50"; // 查阅了关联合同
    public final static String TASKOPERRESULT_CYLRW = "60"; // 查阅了任务
    public final static String TASKOPERRESULT_CJBFBLRW = "70"; // 创建并发布了任务

    /************ 复核标志 ************/
    public final static String REVIEWMARK_WFH = "0"; // 未复核
    public final static String REVIEWMARK_FHTG = "1"; // 复核通过
    public final static String REVIEWMARK_FHBTG = "2"; // 复核不通过

    /************ 购买方式 ************/
    public final static String BUYMODE_XSGM = "1"; // 线上购买
    public final static String BUYMODE_XXGM = "2"; // 线下购买

    /************ 变更项目所在表类型 ************/
    public final static String TABLETYPE_LB = "1"; // 列表
    public final static String TABLETYPE_XB = "2"; // 行表

    /************ 社保险种 ************/
    public final static String SOCIALINSTYPE_YANGLAOBX = "110"; // 养老保险
    public final static String SOCIALINSTYPE_SHIYEBX = "210"; // 失业保险
    public final static String SOCIALINSTYPE_YILIAOBX = "310"; // 医疗保险
    public final static String SOCIALINSTYPE_GSBX = "410"; // 工伤保险
    public final static String SOCIALINSTYPE_SYBX = "510"; // 生育保险

    /************ 增值税纳税人类别 ************/
    public final static String TAXPAYERTYPE_ZZSYBNSR = "1"; // 增值税一般纳税人
    public final static String TAXPAYERTYPE_ZZSXGMNSR = "2"; // 增值税小规模纳税人

    /************ 合同类型 ************/
    public final static String CONTRACTTYPE_QYFWHT = "01"; // 企业服务合同
    public final static String CONTRACTTYPE_LDHT = "02"; // 劳动合同
    public final static String CONTRACTTYPE_LWHTGR = "03"; // 劳务合同-个人
    public final static String CONTRACTTYPE_LWHTD = "04"; // 劳务合同-单位
//    public final static String CONTRACTTYPE_ZQDHT= "05"; // 驻勤点合同


    /************ 合同状态 ************/
    public final static String CONTRACTSTATUS_SIGNED = "1"; // 已签订
    public final static String CONTRACTSTATUS_FULFILL = "2"; // 已完成
    public final static String CONTRACTSTATUS_RENEW = "3"; // 已续签
    public final static String CONTRACTSTATUS_TERMINATION = "9"; // 已终止

    /************ 企业所在方 ************/
    public final static String COMPARTY_JF = "1"; // 甲方
    public final static String COMPARTY_YF = "2"; // 乙方

    /************ 发放/结算方式 ************/
    public final static String DISTRIBUTIONMODE_XS = "1"; // 小时
    public final static String DISTRIBUTIONMODE_R = "2"; // 日
    public final static String DISTRIBUTIONMODE_Z = "3"; // 周
    public final static String DISTRIBUTIONMODE_Y = "4"; // 月
    public final static String DISTRIBUTIONMODE_N = "5"; // 年

    /************ 经济类型 ************/
    public final static String ECONOMICTYPE_GYJJ = "1"; // 国有经济
    public final static String ECONOMICTYPE_JTJJ = "2"; // 集体经济
    public final static String ECONOMICTYPE_SYJJ = "3"; // 私营经济
    public final static String ECONOMICTYPE_GTJJ = "4"; // 个体经济
    public final static String ECONOMICTYPE_LYJJ = "5"; // 联营经济
    public final static String ECONOMICTYPE_GFZ = "6"; // 股份制
    public final static String ECONOMICTYPE_WSTZ = "7"; // 外商投资
    public final static String ECONOMICTYPE_GATTZYQTJJ = "8"; // 港澳台投资与其他经济
    public final static String ECONOMICTYPE_QTJJ = "9"; // 其他经济

    /************ 行业类型 ************/
    public final static String INDUSTRYTYPE_BAXY = "01"; // 保安行业
    public final static String INDUSTRYTYPE_ACTIVITY_XY = "02"; // 大型活动相关行业
    public final static String INDUSTRYTYPE_QTXY = "09"; // 其他行业


    /************ 公司类型 ************/
    public final static String COMTYPE_HZ = "1"; // 合资
    public final static String COMTYPE_DZ = "2"; // 独资
    public final static String COMTYPE_GY = "3"; // 国有
    public final static String COMTYPE_SY = "4"; // 私营
    public final static String COMTYPE_QMSYZ = "5"; // 全民所有制
    public final static String COMTYPE_JTSYZ = "6"; // 集体所有制
    public final static String COMTYPE_GFZ = "7"; // 股份制
    public final static String COMTYPE_YXZR = "8"; // 有限责任
    public final static String COMTYPE_QT = "9"; // 其他

    /************ 机构类型 ************/
    public final static String INSTITUTIONTYPE_BAXH = "0101"; // 保安协会
    public final static String INSTITUTIONTYPE_BAFWGS = "0102"; // 保安服务公司
    public final static String INSTITUTIONTYPE_BAPXDW = "0103"; // 保安培训单位
    public final static String INSTITUTIONTYPE_ZXZYBA = "0104"; // 自行招用保安单位
    public final static String INSTITUTIONTYPE_BAFWGSJFWDW = "0105"; // 保安服务公司及培训单位

    public final static String INSTITUTIONTYPE_PSS_CB = "0202"; // 承办方
    public final static String INSTITUTIONTYPE_PSS_CBGOV = "0203"; // 政府机构
    public final static String INSTITUTIONTYPE_PSS_FW = "0204"; // 服务机构
    public final static String INSTITUTIONTYPE_PSS_FP = "0201"; // 风评机构
    public final static String INSTITUTIONTYPE_PSS_DJFWS = "0205"; // 搭建服务商
    public final static String INSTITUTIONTYPE_PSS_GAJG = "0210"; // 公安机构
    /************ 公司类型 ************/
    public final static String COMPANY_TYPE_PARENT= "0"; // 总公司
    public final static String COMPANY_TYPE_BRANCH= "1"; // 分公司
    public final static String COMPANY_TYPE_SUB= "2"; // 子公司

    /************ 自然人类型 ************/
    public final static String NATURAL_Y= "1"; // 自然人
    public final static String NATURAL_N= "0"; // 非自然人

    /************ 企业证件类型 ************/
    public final static String COMCERTYPE_YYZZ = "1"; // 营业执照（非三证合一）
    public final static String COMCERTYPE_TYSHXYDMZ = "2"; // 统一社会信用代码证


    /************ 开票类型 ************/
    public final static String BIZINVOICETYPE_QB = "0"; // 全部
    public final static String BIZINVOICETYPE_YK = "1"; // 应开
    public final static String BIZINVOICETYPE_YS = "2"; // 应收

    /************ 发票类型 ************/
    public final static String BIZINVOICEMAKETYPE_ZZPP = "1"; // 纸质普票
    public final static String BIZINVOICEMAKETYPE_ZZZP = "2"; // 纸质专票
    public final static String BIZINVOICEMAKETYPE_DZFP = "3"; // 电子发票

    /************ 发票类型 ************/
    public final static String MAKESTATUS_WK = "0"; // 未开
    public final static String MAKESTATUS_IN = "2"; // 开票中（限电子发票已申请）
    public final static String MAKESTATUS_YK = "1"; // 已开票

    /************ 经营模式 ************/
    public final static String MANAGEMODE_HEZI = "1"; // 合资
    public final static String MANAGEMODE_HEZUO = "2"; // 合作
    public final static String MANAGEMODE_DZ = "3"; // 独资

    /************ 身份证件类型 ************/
    public final static String IDCARDTYPE_SFZ = "1"; // 居民身份证（户口簿）
    public final static String IDCARDTYPE_ZGRMJFJJGZ = "2"; // 中国人民解放军军官证
    public final static String IDCARDTYPE_ZGRMWZJCJGZ = "3"; // 中国人民武装警察警官证
    public final static String IDCARDTYPE_XGHZ = "4"; // 香港特区护照/身份证明
    public final static String IDCARDTYPE_AMHZ = "5"; // 澳门特区护照/身份证明
    public final static String IDCARDTYPE_TWJMLWDLTXZ = "6"; // 台湾居民来往大陆通行证
    public final static String IDCARDTYPE_WGRHZ = "8"; // 外国人护照

    /************ 学历 ************/
    public final static String EDUCATION_XX = "1"; // 小学
    public final static String EDUCATION_CZ = "2"; // 初中
    public final static String EDUCATION_GZ = "3"; // 高中
    public final static String EDUCATION_ZZ = "4"; // 中专
    public final static String EDUCATION_BK = "5"; // 本科
    public final static String EDUCATION_DZ = "6"; // 大专
    public final static String EDUCATION_SSYJS = "7"; // 硕士研究生
    public final static String EDUCATION_BS = "8"; // 博士
    public final static String EDUCATION_BSH = "9"; // 博士后

    /************ 职位性质 ************/
    public final static String POSITIONNATURE_QZ = "1"; // 全职
    public final static String POSITIONNATURE_JZ = "2"; // 兼职
    public final static String POSITIONNATURE_SX = "3"; // 实习

    /************ 发布状态 ************/
    public final static String RELEASESTATUS_WFB = "0"; // 未发布
    public final static String RELEASESTATUS_KQ = "1"; // 开启
    public final static String RELEASESTATUS_GB = "2"; // 关闭

    /************ 薪资类型 ************/
    public final static String SALARYTYPE_GDXZ = "1"; // 固定薪资
    public final static String SALARYTYPE_GDXZTC = "2"; // 固定薪资+提成

    /************ 薪资类型（明细项） ************/
    public final static String SALARYTYPE_DETAIL_JBGZ = "1101"; // 基本工资
    public final static String SALARYTYPE_DETAIL_JXGZ = "1102"; // 绩效工资
    public final static String SALARYTYPE_DETAIL_GWBT = "1201"; // 岗位津贴
    public final static String SALARYTYPE_DETAIL_CLBT = "1202"; // 差旅补贴
    public final static String SALARYTYPE_DETAIL_TXBT = "1203"; // 通讯补贴
    public final static String SALARYTYPE_DETAIL_CYBT = "1204"; // 餐饮补贴
    public final static String SALARYTYPE_DETAIL_QTBT = "1209"; // 其他补贴
    public final static String SALARYTYPE_DETAIL_CDKK = "1301"; // 迟到扣款
    public final static String SALARYTYPE_DETAIL_ZTKK = "1302"; // 早退扣款
    public final static String SALARYTYPE_DETAIL_KGKK = "1303"; // 旷工扣款
    public final static String SALARYTYPE_DETAIL_SJKK = "1304"; // 事假扣款
    public final static String SALARYTYPE_DETAIL_BJKK = "1305"; // 病假扣款
    public final static String SALARYTYPE_DETAIL_LKKK = "1309"; // 漏卡扣款
    public final static String SALARYTYPE_DETAIL_GZRJBBT = "1306"; // 工作日加班补贴
    public final static String SALARYTYPE_DETAIL_XXRJBBT = "1307"; // 休息日加班补贴
    public final static String SALARYTYPE_DETAIL_JJRJBBT = "1308"; // 节假日加班补贴
    public final static String SALARYTYPE_DETAIL_WQCDKK = "1401"; // 外勤迟到扣款
    public final static String SALARYTYPE_DETAIL_WQZTKK = "1402"; // 外勤早退扣款
    public final static String SALARYTYPE_DETAIL_WQKGKK = "1403"; // 外勤旷工扣款
    public final static String SALARYTYPE_DETAIL_WQSJKK = "1404"; // 外勤事假扣款
    public final static String SALARYTYPE_DETAIL_WQBJKK = "1405"; // 外勤病假扣款
    public final static String SALARYTYPE_DETAIL_WQLKKK = "1406"; // 外勤漏卡扣款
    public final static String SALARYTYPE_DETAIL_DKYLJ = "3001"; // 代扣养老金
    public final static String SALARYTYPE_DETAIL_DKSYJ = "3002"; // 代扣失业金
    public final static String SALARYTYPE_DETAIL_DKYB = "3003"; // 代扣医保
    public final static String SALARYTYPE_DETAIL_DKGJJ = "3004"; // 代扣公积金
    public final static String SALARYTYPE_DETAIL_GRSDS = "3101"; // 个人所得税

    /************ 福利 ************/
    public final static String WELFARE_WX = "1"; // 五险
    public final static String WELFARE_ZFGJJ = "2"; // 住房公积金
    public final static String WELFARE_BC = "3"; // 包吃
    public final static String WELFARE_BZ = "4"; // 包住
    public final static String WELFARE_JBBZ = "5"; // 加班补助
    public final static String WELFARE_BCJS = "6"; // 班车接送

    /************ 每天工作时间类型 ************/
    public final static String WORKTIMETYPE_BX = "0"; // 不限
    public final static String WORKTIMETYPE_YXS = "1"; // 1小时
    public final static String WORKTIMETYPE_YDWXS = "1.5"; // 1.5小时
    public final static String WORKTIMETYPE_EXS = "2"; // 2小时
    public final static String WORKTIMETYPE_EDWXS = "2.5"; // 2.5小时
    public final static String WORKTIMETYPE_SXS = "3"; // 3小时
    public final static String WORKTIMETYPE_SDWXS = "3.5"; // 3.5小时
    public final static String WORKTIMETYPE_SIXS = "4"; // 4小时
    public final static String WORKTIMETYPE_SIDWXS = "4.5"; // 4.5小时
    public final static String WORKTIMETYPE_WXS = "5"; // 5小时
    public final static String WORKTIMETYPE_WDWXS = "5.5"; // 5.5小时
    public final static String WORKTIMETYPE_LXS = "6"; // 6小时
    public final static String WORKTIMETYPE_LDWXS = "6.5"; // 6.5小时
    public final static String WORKTIMETYPE_QXS = "7"; // 7小时
    public final static String WORKTIMETYPE_QDWXS = "7.5"; // 7.5小时
    public final static String WORKTIMETYPE_BXS = "8"; // 8小时
    public final static String WORKTIMETYPE_BDWXS = "8.5"; // 8.5小时
    public final static String WORKTIMETYPE_JXS = "9"; // 9小时
    public final static String WORKTIMETYPE_JDWXS = "9.5"; // 9.5小时
    public final static String WORKTIMETYPE_SHIXS = "10"; // 10小时
    public final static String WORKTIMETYPE_SHIDWXS = "10.5"; // 10.5小时
    public final static String WORKTIMETYPE_SYXS = "11"; // 11小时
    public final static String WORKTIMETYPE_SYDWXS = "11.5"; // 11.5小时
    public final static String WORKTIMETYPE_SEXS = "12"; // 12小时

    /************ 每周工作天数类型 ************/
    public final static String WORKDAYTYPE_BX = "0"; // 不限
    public final static String WORKDAYTYPE_YT = "1"; // 1天
    public final static String WORKDAYTYPE_ET = "2"; // 2天
    public final static String WORKDAYTYPE_ST = "3"; // 3天
    public final static String WORKDAYTYPE_SIT = "4"; // 4天
    public final static String WORKDAYTYPE_WT = "5"; // 5天
    public final static String WORKDAYTYPE_LT = "6"; // 6天
    public final static String WORKDAYTYPE_QT = "7"; // 7天

    /************ 工作年限类型 ************/
    public final static String WORKLIFETYPE_BX = ""; // 不限
    public final static String WORKLIFETYPE_YJ = "0"; // 应届
    public final static String WORKLIFETYPE_YNYS = "1"; // 1年以上
    public final static String WORKLIFETYPE_ENYS = "2"; // 2年以上
    public final static String WORKLIFETYPE_SNYS = "3"; // 3年以上
    public final static String WORKLIFETYPE_SINYS = "4"; // 4年以上
    public final static String WORKLIFETYPE_WNYS = "5"; // 5年以上
    public final static String WORKLIFETYPE_LNYS = "6"; // 6年以上
    public final static String WORKLIFETYPE_QNYS = "7"; // 7年以上
    public final static String WORKLIFETYPE_BNYS = "8"; // 8年以上
    public final static String WORKLIFETYPE_JNYS = "9"; // 9年以上
    public final static String WORKLIFETYPE_SHINYS = "10"; // 10年以上

    /************ 最低学历 ************/
    public final static String EDUCATIONLOW_BX = "0"; // 不限
    public final static String EDUCATIONLOW_XX = "1"; // 小学
    public final static String EDUCATIONLOW_CZ = "2"; // 初中
    public final static String EDUCATIONLOW_GZ = "3"; // 高中
    public final static String EDUCATIONLOW_ZZ = "4"; // 中专
    public final static String EDUCATIONLOW_BK = "5"; // 本科
    public final static String EDUCATIONLOW_DZ = "6"; // 大专
    public final static String EDUCATIONLOW_SSYJS = "7"; // 硕士研究生
    public final static String EDUCATIONLOW_BS = "8"; // 博士
    public final static String EDUCATIONLOW_BSH = "9"; // 博士后

    /************ 性别 ************/
    public final static String SEX_NAN = "1"; // 男
    public final static String SEX_NV = "2"; // 女
    public final static String SEX_WSMXB = "9"; // 未说明性别

    /************ 性别要求 ************/
    public final static String SEXREQUIRE_BX = "0"; // 不限
    public final static String SEXREQUIRE_NAN = "1"; // 男
    public final static String SEXREQUIRE_NV = "2"; // 女

    /************ 股东类别 ************/
    public final static String SHAREHOLDERTYPE_ZRRGD = "1"; // 自然人股东
    public final static String SHAREHOLDERTYPE_JGGD = "2"; // 机构股东

    /************ 出资方式 ************/
    public final static String CONTRIBUTIONMODE_HB = "1"; // 货币
    public final static String CONTRIBUTIONMODE_SW = "2"; // 实物
    public final static String CONTRIBUTIONMODE_ZSCQ = "3"; // 知识产权
    public final static String CONTRIBUTIONMODE_TDSYQ = "4"; // 土地使用权

    /************ 股权变更类型 ************/
    public final static String STOCKCHANGETYPE_ZZ = "1"; // 增资
    public final static String STOCKCHANGETYPE_JZ = "2"; // 减资
    public final static String STOCKCHANGETYPE_GQZR = "3"; // 股权转让

    /************ 股权调整类型 ************/
    public final static String STOCKADJUSTTYPE_DZJE = "1"; // 调整金额
    public final static String STOCKADJUSTTYPE_DZDGDJE = "2"; // 调整到固定金额
    public final static String STOCKADJUSTTYPE_DZBL = "3"; // 调整比例

    /************ 报表类型 ************/
    public final static String REPORTTYPE_PTBB = "1"; // 普通报表
    public final static String REPORTTYPE_YDBB = "2"; // 月度报表

    /************ 出入库类型 ************/
    public final static String INOUTSTOCKTYPE_SBCK = "1"; // 设备出库
    public final static String INOUTSTOCKTYPE_SBRK = "2"; // 设备入库
    public final static String INOUTSTOCKTYPE_KCXZ = "3"; // 库存新增
    public final static String INOUTSTOCKTYPE_KCBF = "4"; // 库存报废

    /************ 安保范围 ************/
    public final static String SECURITYRANGE_MW = "01"; // 门卫
    public final static String SECURITYRANGE_XL = "02"; // 巡逻
    public final static String SECURITYRANGE_SH = "03"; // 守护
    public final static String SECURITYRANGE_YY = "04"; // 押运
    public final static String SECURITYRANGE_SSHW = "05"; // 随身护卫
    public final static String SECURITYRANGE_AQJC = "06"; // 安全检查
    public final static String SECURITYRANGE_QYZXWH = "07"; // 区域秩序维护
    public final static String SECURITYRANGE_AQFXPG = "08"; // 安全风险评估
    public final static String SECURITYRANGE_AQJSFF = "09"; // 安全技术防范
    public final static String SECURITYRANGE_QT = "10"; // 其他

    /************ 处罚类型 ************/
    public final static String PENALTYTYPE_JG = "01"; // 警告
    public final static String PENALTYTYPE_FK = "02"; // 罚款
    public final static String PENALTYTYPE_DXBAYZ = "03"; // 吊销保安员证
    public final static String PENALTYTYPE_SDZAGLCF = "04"; // 受到治安管理处罚
    public final static String PENALTYTYPE_MSFFSD = "05"; // 没收非法所得
    public final static String PENALTYTYPE_ZJXSXZ = "06"; // 追究形式刑责
    public final static String PENALTYTYPE_FFPXDW = "07"; // 非法培训单位
    public final static String PENALTYTYPE_WGPX = "08"; // 违规培训
    public final static String PENALTYTYPE_PXZP = "09"; // 培训诈骗
    public final static String PENALTYTYPE_QT = "10"; // 其他

    /************ 表彰类型 ************/
    public final static String AWARDTYPE_JYYW = "01"; // 见义勇为
    public final static String AWARDTYPE_YGFS = "02"; // 因公负伤
    public final static String AWARDTYPE_YGXS = "03"; // 因公牺牲
    public final static String AWARDTYPE_XJJTQG = "04"; // 先进集体-全国
    public final static String AWARDTYPE_XJJTSJ = "05"; // 先进集体-省级
    public final static String AWARDTYPE_XJGRQG = "06"; // 先进个人-全国
    public final static String AWARDTYPE_XJGRSJ = "07"; // 先进个人-省级
    public final static String AWARDTYPE_GPAXS = "08"; // 供破案线索
    public final static String AWARDTYPE_ZHXYR = "09"; // 抓获嫌疑人
    public final static String AWARDTYPE_YFZHSG = "10"; // 预防灾害事故
    public final static String AWARDTYPE_QT = "11"; // 其他

    /************ 数据权限标志 ************/
    public final static String DATAAUTHFLAG_S = "1"; // 是
    public final static String DATAAUTHFLAG_F = "0"; // 否

    /************ 是否休息 ************/
    public final static String ISREST_TRUE = "1"; // 是
    public final static String ISREST_FALSE = "0"; // 否

    /************ 区域级别 ************/
    public final static String REGIONLEVEL_SHENG = "1"; // 省
    public final static String REGIONLEVEL_SHI = "2"; // 市
    public final static String REGIONLEVEL_QX = "3"; // 区/县

    /************ 客户端类型 ************/
    public final static String CLIENTTYPE_web = "web"; // web
    public final static String CLIENTTYPE_android = "android"; // android
    public final static String CLIENTTYPE_ios = "ios"; // ios

    /************ 客户端类型 ************/
    public final static String ORGTYPE_GS = "1"; // 公司
    public final static String ORGTYPE_BM = "2"; // 部门

    /************ 上级组织类型 ************/
    public final static String PARENTORGTYPE_GS = "1"; // 公司
    public final static String PARENTORGTYPE_BM = "2"; // 部门

    /************ 角色类型 ************/
    public final static String ROLETYPE_ZHUGLY = "1"; // 主管理员
    public final static String ROLETYPE_ZIGLY = "2"; // 子管理员
    public final static String ROLETYPE_BMGLY = "3"; // 部门管理员
    public final static String ROLETYPE_PT = "4"; // 普通

    /************ 角色数据权限类型 ************/
    public final static String DATAAUTHTYPE_QGS = "1"; // 全公司
    public final static String DATAAUTHTYPE_SZBM = "2"; // 所在部门
    public final static String DATAAUTHTYPE_SZBMJXJBM = "3"; // 所在部门及下级部门
    public final static String DATAAUTHTYPE_TDBM = "4"; // 特定部门

    /************ 民族 ************/
    public final static String NATION_HANZ = "01"; // 汉族
    public final static String NATION_MGZ = "02"; // 蒙古族
    public final static String NATION_HZ = "03"; // 回族
    public final static String NATION_CZ = "04"; // 藏族
    public final static String NATION_WWEZ = "05"; // 维吾尔族
    public final static String NATION_MIAOZ = "06"; // 苗族
    public final static String NATION_YIZ = "07"; // 彝族
    public final static String NATION_ZHAUNGZ = "08"; // 壮族
    public final static String NATION_BYZ = "09"; // 布依族
    public final static String NATION_CXZ = "10"; // 朝鲜族
    public final static String NATION_MZ = "11"; // 满族
    public final static String NATION_DONGZ = "12"; // 侗族
    public final static String NATION_YZ = "13"; // 瑶族
    public final static String NATION_BZ = "14"; // 白族
    public final static String NATION_TJZ = "15"; // 土家族
    public final static String NATION_HNZ = "16"; // 哈尼族
    public final static String NATION_HSKZ = "17"; // 哈萨克族
    public final static String NATION_DZ = "18"; // 傣族
    public final static String NATION_LZ = "19"; // 黎族
    public final static String NATION_LSZ = "20"; // 傈僳族
    public final static String NATION_WZ = "21"; // 佤族
    public final static String NATION_ZZ = "22"; // 畲族
    public final static String NATION_GSZ = "23"; // 高山族
    public final static String NATION_LZZ = "24"; // 拉祜族
    public final static String NATION_SZ = "25"; // 水族
    public final static String NATION_DXZ = "26"; // 东乡族
    public final static String NATION_NXZ = "27"; // 纳西族
    public final static String NATION_JPZ = "28"; // 景颇族
    public final static String NATION_KEKZZ = "29"; // 柯尔克孜族
    public final static String NATION_TZ = "30"; // 土族
    public final static String NATION_DWEZ = "31"; // 达斡尔族
    public final static String NATION_MLZ = "32"; // 仫佬族
    public final static String NATION_QZ = "33"; // 羌族
    public final static String NATION_BULZ = "34"; // 布朗族
    public final static String NATION_SLZ = "35"; // 撒拉族
    public final static String NATION_MNZ = "36"; // 毛难族
    public final static String NATION_YLZ = "37"; // 仡佬族
    public final static String NATION_XBZ = "38"; // 锡伯族
    public final static String NATION_ACZ = "39"; // 阿昌族
    public final static String NATION_PMZ = "40"; // 普米族
    public final static String NATION_TJKZ = "41"; // 塔吉克族
    public final static String NATION_NZ = "42"; // 怒族
    public final static String NATION_WZBKZ = "43"; // 乌孜别克族
    public final static String NATION_ELSZ = "44"; // 俄罗斯族
    public final static String NATION_EWKZ = "45"; // 鄂温克族
    public final static String NATION_BLZ = "46"; // 崩龙族
    public final static String NATION_BAZ = "47"; // 保安族
    public final static String NATION_YGZ = "48"; // 裕固族
    public final static String NATION_JZ = "49"; // 京族
    public final static String NATION_TTEZ = "50"; // 塔塔尔族
    public final static String NATION_DLZ = "51"; // 独龙族
    public final static String NATION_ELCZ = "52"; // 鄂伦春族
    public final static String NATION_HZZ = "53"; // 赫哲族
    public final static String NATION_MBZ = "54"; // 门巴族
    public final static String NATION_ZBZ = "55"; // 珞巴族
    public final static String NATION_JNZ = "56"; // 基诺族
    public final static String NATION_QT = "97"; // 其他
    public final static String NATION_WGXTZGJRS = "98"; // 外国血统中国籍人士

    /************ 国籍 ************/
    public final static String NATIONALITY_ABW = "ABW"; // 阿鲁巴
    public final static String NATIONALITY_AFG = "AFG"; // 阿富汗
    public final static String NATIONALITY_AGO = "AGO"; // 安哥拉
    public final static String NATIONALITY_AIA = "AIA"; // 安圭拉
    public final static String NATIONALITY_ALB = "ALB"; // 阿尔巴尼亚
    public final static String NATIONALITY_AND = "AND"; // 安道尔
    public final static String NATIONALITY_ANT = "ANT"; // 荷属安的列斯
    public final static String NATIONALITY_ARE = "ARE"; // 阿联酋
    public final static String NATIONALITY_ARG = "ARG"; // 阿根廷
    public final static String NATIONALITY_ARM = "ARM"; // 亚美尼亚
    public final static String NATIONALITY_ASM = "ASM"; // 美属萨摩亚
    public final static String NATIONALITY_ATA = "ATA"; // 南极洲
    public final static String NATIONALITY_ATF = "ATF"; // 法属南部领土
    public final static String NATIONALITY_ATG = "ATG"; // 安提瓜和巴布达
    public final static String NATIONALITY_AUS = "AUS"; // 澳大利亚
    public final static String NATIONALITY_AUT = "AUT"; // 奥地利
    public final static String NATIONALITY_AZE = "AZE"; // 阿塞拜疆
    public final static String NATIONALITY_BDI = "BDI"; // 布隆迪
    public final static String NATIONALITY_BEL = "BEL"; // 比利时
    public final static String NATIONALITY_BEN = "BEN"; // 贝宁
    public final static String NATIONALITY_BFA = "BFA"; // 布基纳法索
    public final static String NATIONALITY_BGD = "BGD"; // 孟加拉国
    public final static String NATIONALITY_BGR = "BGR"; // 保加利亚
    public final static String NATIONALITY_BHR = "BHR"; // 巴林
    public final static String NATIONALITY_BHS = "BHS"; // 巴哈马
    public final static String NATIONALITY_BIH = "BIH"; // 波斯尼亚和黑塞哥维那
    public final static String NATIONALITY_BLR = "BLR"; // 白俄罗斯
    public final static String NATIONALITY_BLZ = "BLZ"; // 伯利兹
    public final static String NATIONALITY_BMU = "BMU"; // 百幕大
    public final static String NATIONALITY_BOL = "BOL"; // 玻利维亚
    public final static String NATIONALITY_BRA = "BRA"; // 巴西
    public final static String NATIONALITY_BRB = "BRB"; // 巴巴多斯
    public final static String NATIONALITY_BRN = "BRN"; // 文莱
    public final static String NATIONALITY_BTN = "BTN"; // 不丹
    public final static String NATIONALITY_BVT = "BVT"; // 布维岛
    public final static String NATIONALITY_BWA = "BWA"; // 博茨瓦纳
    public final static String NATIONALITY_CAF = "CAF"; // 中非
    public final static String NATIONALITY_CAN = "CAN"; // 加拿大
    public final static String NATIONALITY_CCK = "CCK"; // 科科斯群岛
    public final static String NATIONALITY_CHE = "CHE"; // 瑞士
    public final static String NATIONALITY_CHL = "CHL"; // 智利
    public final static String NATIONALITY_CHN = "CHN"; // 中国
    public final static String NATIONALITY_CIV = "CIV"; // 科特迪瓦
    public final static String NATIONALITY_CMR = "CMR"; // 喀麦隆
    public final static String NATIONALITY_COD = "COD"; // 刚果民主共和国
    public final static String NATIONALITY_COG = "COG"; // 刚果
    public final static String NATIONALITY_COK = "COK"; // 库克群岛
    public final static String NATIONALITY_COL = "COL"; // 哥伦比亚
    public final static String NATIONALITY_COM = "COM"; // 科摩罗
    public final static String NATIONALITY_CPV = "CPV"; // 佛得角
    public final static String NATIONALITY_CRI = "CRI"; // 哥斯达黎加
    public final static String NATIONALITY_CUB = "CUB"; // 古巴
    public final static String NATIONALITY_CXR = "CXR"; // 圣诞岛
    public final static String NATIONALITY_CYM = "CYM"; // 开曼群岛
    public final static String NATIONALITY_CYP = "CYP"; // 塞浦路斯
    public final static String NATIONALITY_CZE = "CZE"; // 捷克
    public final static String NATIONALITY_DEU = "DEU"; // 德国
    public final static String NATIONALITY_DJI = "DJI"; // 吉布提
    public final static String NATIONALITY_DMA = "DMA"; // 多米尼加
    public final static String NATIONALITY_DNK = "DNK"; // 丹麦
    public final static String NATIONALITY_DOM = "DOM"; // 多米尼家共和国
    public final static String NATIONALITY_DZA = "DZA"; // 阿尔及利亚
    public final static String NATIONALITY_ECU = "ECU"; // 厄瓜多尔
    public final static String NATIONALITY_EGY = "EGY"; // 埃及
    public final static String NATIONALITY_ERI = "ERI"; // 厄立特里亚
    public final static String NATIONALITY_ESH = "ESH"; // 西撒哈拉
    public final static String NATIONALITY_ESP = "ESP"; // 西班牙
    public final static String NATIONALITY_EST = "EST"; // 爱沙尼亚
    public final static String NATIONALITY_ETH = "ETH"; // 埃塞俄比亚
    public final static String NATIONALITY_FIN = "FIN"; // 芬兰
    public final static String NATIONALITY_FJI = "FJI"; // 斐济
    public final static String NATIONALITY_FLK = "FLK"; // 马尔维纳斯群岛
    public final static String NATIONALITY_FRA = "FRA"; // 法国
    public final static String NATIONALITY_FRO = "FRO"; // 法罗群岛
    public final static String NATIONALITY_FSM = "FSM"; // 密克罗尼西亚
    public final static String NATIONALITY_GAB = "GAB"; // 加蓬
    public final static String NATIONALITY_GBD = "GBD"; // 英国（独立领土公民、出国不用）
    public final static String NATIONALITY_GBN = "GBN"; // 英国（海外国民，出国不用）
    public final static String NATIONALITY_GBO = "GBO"; // 英国（海外公民，出国不用）
    public final static String NATIONALITY_GBP = "GBP"; // 英国（保护公民，出国不用）
    public final static String NATIONALITY_GBR = "GBR"; // 英国
    public final static String NATIONALITY_GBS = "GBS"; // 英国（隶属，出国不用）
    public final static String NATIONALITY_GEO = "GEO"; // 格鲁吉亚
    public final static String NATIONALITY_GHA = "GHA"; // 加纳
    public final static String NATIONALITY_GIB = "GIB"; // 直布罗陀
    public final static String NATIONALITY_GIN = "GIN"; // 几内亚
    public final static String NATIONALITY_GLP = "GLP"; // 瓜德罗普
    public final static String NATIONALITY_GMB = "GMB"; // 冈比亚
    public final static String NATIONALITY_GNB = "GNB"; // 几内亚比绍
    public final static String NATIONALITY_GNQ = "GNQ"; // 赤道几内亚
    public final static String NATIONALITY_GRC = "GRC"; // 希腊
    public final static String NATIONALITY_GRD = "GRD"; // 格林纳达
    public final static String NATIONALITY_GRL = "GRL"; // 格陵兰
    public final static String NATIONALITY_GTM = "GTM"; // 危地马拉
    public final static String NATIONALITY_GUF = "GUF"; // 法属圭亚那
    public final static String NATIONALITY_GUM = "GUM"; // 关岛
    public final static String NATIONALITY_GUY = "GUY"; // 圭亚那
    public final static String NATIONALITY_HKG = "HKG"; // 香港
    public final static String NATIONALITY_HMD = "HMD"; // 赫德岛和麦克唐纳岛
    public final static String NATIONALITY_HND = "HND"; // 洪都拉斯
    public final static String NATIONALITY_HRV = "HRV"; // 克罗地亚
    public final static String NATIONALITY_HTI = "HTI"; // 海地
    public final static String NATIONALITY_HUN = "HUN"; // 匈牙利
    public final static String NATIONALITY_IDN = "IDN"; // 印度尼西亚
    public final static String NATIONALITY_IND = "IND"; // 印度
    public final static String NATIONALITY_IOT = "IOT"; // 英属印度洋领土
    public final static String NATIONALITY_IRL = "IRL"; // 爱尔兰
    public final static String NATIONALITY_IRN = "IRN"; // 伊朗
    public final static String NATIONALITY_IRQ = "IRQ"; // 伊拉克
    public final static String NATIONALITY_ISL = "ISL"; // 冰岛
    public final static String NATIONALITY_ISR = "ISR"; // 以色列
    public final static String NATIONALITY_ITA = "ITA"; // 意大利
    public final static String NATIONALITY_JAM = "JAM"; // 牙买加
    public final static String NATIONALITY_JOR = "JOR"; // 约旦
    public final static String NATIONALITY_JPN = "JPN"; // 日本
    public final static String NATIONALITY_JTN = "JTN"; // 约翰斯顿岛
    public final static String NATIONALITY_KAZ = "KAZ"; // 哈萨克斯坦
    public final static String NATIONALITY_KEN = "KEN"; // 肯尼亚
    public final static String NATIONALITY_KGZ = "KGZ"; // 吉尔吉斯斯坦
    public final static String NATIONALITY_KHM = "KHM"; // 柬埔寨
    public final static String NATIONALITY_KIR = "KIR"; // 基里巴斯
    public final static String NATIONALITY_KNA = "KNA"; // 圣基茨和尼维斯
    public final static String NATIONALITY_KOR = "KOR"; // 韩国（南朝鲜）
    public final static String NATIONALITY_KWT = "KWT"; // 科威特
    public final static String NATIONALITY_LAO = "LAO"; // 老挝
    public final static String NATIONALITY_LBN = "LBN"; // 黎巴嫩
    public final static String NATIONALITY_LBR = "LBR"; // 利比里亚
    public final static String NATIONALITY_LBY = "LBY"; // 利比亚
    public final static String NATIONALITY_LCA = "LCA"; // 圣卢西亚
    public final static String NATIONALITY_LIE = "LIE"; // 列支敦土登
    public final static String NATIONALITY_LKA = "LKA"; // 斯里兰卡
    public final static String NATIONALITY_LSO = "LSO"; // 莱索托
    public final static String NATIONALITY_LTU = "LTU"; // 立陶宛
    public final static String NATIONALITY_LUX = "LUX"; // 卢森堡
    public final static String NATIONALITY_LVA = "LVA"; // 拉脱维亚
    public final static String NATIONALITY_MAC = "MAC"; // 澳门
    public final static String NATIONALITY_MAR = "MAR"; // 摩洛哥
    public final static String NATIONALITY_MCO = "MCO"; // 摩纳哥
    public final static String NATIONALITY_MDA = "MDA"; // 摩尔多瓦
    public final static String NATIONALITY_MDG = "MDG"; // 马达加斯加
    public final static String NATIONALITY_MDV = "MDV"; // 马尔代夫
    public final static String NATIONALITY_MEX = "MEX"; // 墨西哥
    public final static String NATIONALITY_MHL = "MHL"; // 马绍尔群岛
    public final static String NATIONALITY_MID = "MID"; // 中途岛
    public final static String NATIONALITY_MKD = "MKD"; // 马其顿
    public final static String NATIONALITY_MLI = "MLI"; // 马里
    public final static String NATIONALITY_MLT = "MLT"; // 马耳他
    public final static String NATIONALITY_MMR = "MMR"; // 缅甸
    public final static String NATIONALITY_MNG = "MNG"; // 蒙古
    public final static String NATIONALITY_MNP = "MNP"; // 北马里亚纳
    public final static String NATIONALITY_MOZ = "MOZ"; // 莫桑比克
    public final static String NATIONALITY_MRT = "MRT"; // 毛里塔尼亚
    public final static String NATIONALITY_MSR = "MSR"; // 蒙特塞拉特
    public final static String NATIONALITY_MTQ = "MTQ"; // 马提尼克
    public final static String NATIONALITY_MUS = "MUS"; // 毛里求斯
    public final static String NATIONALITY_MWI = "MWI"; // 马拉维
    public final static String NATIONALITY_MYS = "MYS"; // 马来西亚
    public final static String NATIONALITY_MYT = "MYT"; // 马约特
    public final static String NATIONALITY_NAM = "NAM"; // 纳米比亚
    public final static String NATIONALITY_NCL = "NCL"; // 新喀里多尼亚
    public final static String NATIONALITY_NER = "NER"; // 尼日尔
    public final static String NATIONALITY_NFK = "NFK"; // 诺福克岛
    public final static String NATIONALITY_NGA = "NGA"; // 尼日利亚
    public final static String NATIONALITY_NIC = "NIC"; // 尼加拉瓜
    public final static String NATIONALITY_NIU = "NIU"; // 纽埃
    public final static String NATIONALITY_NLD = "NLD"; // 荷兰
    public final static String NATIONALITY_NOR = "NOR"; // 挪威
    public final static String NATIONALITY_NPL = "NPL"; // 尼波尔
    public final static String NATIONALITY_NRU = "NRU"; // 瑙鲁
    public final static String NATIONALITY_NTZ = "NTZ"; // 中间地带
    public final static String NATIONALITY_NZL = "NZL"; // 新西兰
    public final static String NATIONALITY_OMN = "OMN"; // 阿曼
    public final static String NATIONALITY_PAK = "PAK"; // 巴基斯坦
    public final static String NATIONALITY_PAN = "PAN"; // 巴拿马
    public final static String NATIONALITY_PCN = "PCN"; // 皮特凯恩群岛
    public final static String NATIONALITY_PER = "PER"; // 秘鲁
    public final static String NATIONALITY_PHL = "PHL"; // 菲律宾
    public final static String NATIONALITY_PLW = "PLW"; // 贝劳
    public final static String NATIONALITY_PNG = "PNG"; // 巴布亚新几内亚
    public final static String NATIONALITY_POL = "POL"; // 波兰
    public final static String NATIONALITY_PRI = "PRI"; // 波多黎各
    public final static String NATIONALITY_PRK = "PRK"; // 朝鲜
    public final static String NATIONALITY_PRT = "PRT"; // 葡萄牙
    public final static String NATIONALITY_PRY = "PRY"; // 巴拉圭
    public final static String NATIONALITY_PST = "PST"; // 巴勒斯坦
    public final static String NATIONALITY_PYF = "PYF"; // 法属菠利尼西亚
    public final static String NATIONALITY_QAT = "QAT"; // 卡塔尔
    public final static String NATIONALITY_REU = "REU"; // 留尼汪
    public final static String NATIONALITY_ROM = "ROM"; // 罗马尼亚
    public final static String NATIONALITY_RUS = "RUS"; // 俄罗斯
    public final static String NATIONALITY_RWA = "RWA"; // 卢旺达
    public final static String NATIONALITY_SAU = "SAU"; // 沙特阿拉伯
    public final static String NATIONALITY_SDN = "SDN"; // 苏丹
    public final static String NATIONALITY_SEN = "SEN"; // 塞内加尔
    public final static String NATIONALITY_SF = "SF"; // 塞尔维亚
    public final static String NATIONALITY_SGP = "SGP"; // 新加坡
    public final static String NATIONALITY_SGS = "SGS"; // 南乔治亚岛和南桑德韦奇岛
    public final static String NATIONALITY_SHN = "SHN"; // 圣赫勒拿
    public final static String NATIONALITY_SJM = "SJM"; // 斯瓦尔巴群岛
    public final static String NATIONALITY_SLB = "SLB"; // 所罗门群岛
    public final static String NATIONALITY_SLE = "SLE"; // 塞拉利昂
    public final static String NATIONALITY_SLV = "SLV"; // 萨尔瓦多
    public final static String NATIONALITY_SMR = "SMR"; // 圣马力诺
    public final static String NATIONALITY_SOM = "SOM"; // 索马里
    public final static String NATIONALITY_SPM = "SPM"; // 圣皮埃尔和密克隆
    public final static String NATIONALITY_SS = "SS"; // 塞班
    public final static String NATIONALITY_STP = "STP"; // 圣多美和普林西比
    public final static String NATIONALITY_SUR = "SUR"; // 苏里南
    public final static String NATIONALITY_SVK = "SVK"; // 斯洛伐克
    public final static String NATIONALITY_SVN = "SVN"; // 斯洛文尼亚
    public final static String NATIONALITY_SWE = "SWE"; // 瑞典
    public final static String NATIONALITY_SWZ = "SWZ"; // 斯威士兰
    public final static String NATIONALITY_SX = "SX"; // 锡金
    public final static String NATIONALITY_SYC = "SYC"; // 塞舌尔
    public final static String NATIONALITY_SYR = "SYR"; // 叙利亚
    public final static String NATIONALITY_TCA = "TCA"; // 特克斯和凯科斯群岛
    public final static String NATIONALITY_TCD = "TCD"; // 乍得
    public final static String NATIONALITY_TGO = "TGO"; // 多哥
    public final static String NATIONALITY_THA = "THA"; // 泰国
    public final static String NATIONALITY_TJK = "TJK"; // 塔吉克斯坦
    public final static String NATIONALITY_TKL = "TKL"; // 托克劳
    public final static String NATIONALITY_TKM = "TKM"; // 土库曼斯坦
    public final static String NATIONALITY_TMP = "TMP"; // 东帝汶
    public final static String NATIONALITY_TON = "TON"; // 汤加
    public final static String NATIONALITY_TTO = "TTO"; // 特立尼达和多巴哥
    public final static String NATIONALITY_TUN = "TUN"; // 突尼斯
    public final static String NATIONALITY_TUR = "TUR"; // 土耳其
    public final static String NATIONALITY_TUV = "TUV"; // 图瓦卢
    public final static String NATIONALITY_TWN = "TWN"; // 台湾
    public final static String NATIONALITY_TZA = "TZA"; // 坦桑尼亚
    public final static String NATIONALITY_UGA = "UGA"; // 乌干达
    public final static String NATIONALITY_UKR = "UKR"; // 乌克兰
    public final static String NATIONALITY_UMI = "UMI"; // 美属太平洋各群岛
    public final static String NATIONALITY_UN = "UN"; // 联合国
    public final static String NATIONALITY_UNA = "UNA"; // 联合国
    public final static String NATIONALITY_UNO = "UNO"; // 联合国
    public final static String NATIONALITY_URY = "URY"; // 乌拉圭
    public final static String NATIONALITY_USA = "USA"; // 美国
    public final static String NATIONALITY_UZB = "UZB"; // 乌兹别克斯坦
    public final static String NATIONALITY_VAT = "VAT"; // 梵蒂冈
    public final static String NATIONALITY_VCT = "VCT"; // 圣文森特和格林纳丁斯
    public final static String NATIONALITY_VEN = "VEN"; // 委内瑞拉
    public final static String NATIONALITY_VGB = "VGB"; // 英属维尔京群岛
    public final static String NATIONALITY_VIR = "VIR"; // 美属维尔京群岛
    public final static String NATIONALITY_VNM = "VNM"; // 越南
    public final static String NATIONALITY_VUT = "VUT"; // 瓦努阿图
    public final static String NATIONALITY_WAK = "WAK"; // 威克岛
    public final static String NATIONALITY_WLF = "WLF"; // 瓦利斯和富图纳群岛
    public final static String NATIONALITY_WSM = "WSM"; // 西萨摩亚
    public final static String NATIONALITY_XXA = "XXA"; // 无国籍（无国籍人）
    public final static String NATIONALITY_XXB = "XXB"; // 无国籍（难民）
    public final static String NATIONALITY_XXX = "XXX"; // 无国籍（未声明国籍）
    public final static String NATIONALITY_YEM = "YEM"; // 也门
    public final static String NATIONALITY_YUG = "YUG"; // 南斯拉夫
    public final static String NATIONALITY_ZAF = "ZAF"; // 南非
    public final static String NATIONALITY_ZAR = "ZAR"; // 扎伊尔
    public final static String NATIONALITY_ZMB = "ZMB"; // 赞比亚
    public final static String NATIONALITY_ZWE = "ZWE"; // 津巴布韦
    public final static String NATIONALITY_ZZZ = "ZZZ"; // 国籍不详）
    public final static String NATIONALITY_YM = "YEM"; // 也门
    public final static String NATIONALITY_NSLF = "YUG"; // 南斯拉夫
    public final static String NATIONALITY_NF = "ZAF"; // 南非
    public final static String NATIONALITY_ZYE = "ZAR"; // 扎伊尔
    public final static String NATIONALITY_ZBY = "ZMB"; // 赞比亚
    public final static String NATIONALITY_JBBW = "ZWE"; // 津巴布韦
    public final static String NATIONALITY_GJBX = "ZZZ"; // 国籍不详

    /************ 班次类型 ************/
    public final static String SHIFTTYPE_JSBC = "1"; // 计时班次
    public final static String SHIFTTYPE_JCBC = "2"; // 计次班次

    /************ 生效规则 ************/
    public final static String EFFECTRULE_JRSX = "1"; // 今日生效
    public final static String EFFECTRULE_MRSX = "2"; // 明日生效

    /************ 设备类型 ************/
    public final static String EQUIPTYPE_AFQX = "1"; // 安防器械
    public final static String EQUIPTYPE_FHZB = "2"; // 防护装备
    public final static String EQUIPTYPE_AJPB = "3"; // 安检排爆
    public final static String EQUIPTYPE_TXSB = "4"; // 通信设备
    public final static String EQUIPTYPE_XFJY = "5"; // 消防救援
    public final static String EQUIPTYPE_DLGL = "6"; // 道路管理
    public final static String EQUIPTYPE_JKSB = "7"; // 监控设备
    public final static String EQUIPTYPE_JTGJ = "8"; // 交通工具
    public final static String EQUIPTYPE_QTSB = "9"; // 其他设备

    /************ 字段类型 ************/
    public final static String FIELDTYPE_WBK = "1"; // 文本框
    public final static String FIELDTYPE_SZK = "2"; // 数字框
    public final static String FIELDTYPE_RQ = "3"; // 日期
    public final static String FIELDTYPE_XLK = "4"; // 下拉框
    public final static String FIELDTYPE_DANXK = "5"; // 多选框
    public final static String FIELDTYPE_DUOXK = "6"; // 单选框
    public final static String FIELDTYPE_WJ = "7"; // 文件
    public final static String FIELDTYPE_TP = "8"; // 图片

    /************ 休息状态 ************/
    public final static String ISREST_Y = "1"; // 休息
    public final static String ISREST_N = "0"; // 正常

    /************ 是否缺岗 ************/
    public final static String QG_Y = "1"; // 是
    public final static String QG_N = "0"; // 否

    /************ 出勤状态 ************/
    public final static String CQ_XX = "0"; // 休息
    public final static String CQ_ZC = "1"; // 正常
    public final static String CQ_YC = "3"; // 异常
    public final static String CQ_QG = "2"; // 缺岗

    /************ 出勤状态 ************/
    public final static String ATTENDSTATUS_ZC = "1"; // 正常
    public final static String ATTENDSTATUS_CD = "2"; // 迟到
    public final static String ATTENDSTATUS_ZT = "3"; // 早退
    public final static String ATTENDSTATUS_QG = "4"; // 缺岗
    public final static String ATTENDSTATUS_QK = "5"; // 缺卡
    public final static String ATTENDSTATUS_JB = "6"; // 加班
    public final static String ATTENDSTATUS_QJ = "7"; // 请假
    public final static String ATTENDSTATUS_XX = "8"; // 休息

    /************ 认证类型 ************/
    public final static String AUTHTYPE_GARZ = "1"; // 公安认证
    public final static String AUTHTYPE_GSRZ = "2"; // 工商认证
    public final static String AUTHTYPE_PTRZ = "3"; // 平台认证

    /************ 认证状态 ************/
    public final static String AUTHSTATUS_WRZ = "0"; // 未认证
    public final static String AUTHSTATUS_RZTG = "1"; // 认证通过
    public final static String AUTHSTATUS_RZZ = "2"; // 认证中
    public final static String AUTHSTATUS_RZBTG = "3"; // 认证不通过

    /************ 认证类型 ************/
    public final static String AUTHRESULTTYPE_RZTG = "1"; // 认证通过
    public final static String AUTHRESULTTYPE_RZBTG_2 = "2"; // 身份证号和姓名不匹配
    public final static String AUTHRESULTTYPE_RZBTG_3 = "3"; // 人口库无照片
    public final static String AUTHRESULTTYPE_RZBTG_4 = "4"; // 身份证号不存在
    public final static String AUTHRESULTTYPE_RZBTG_5 = "5"; // 人脸照片与身份证信息不匹配

    /************ 采集状态 ************/
    public final static String COLLECT_N = "0"; // 未采集
    public final static String COLLECT_Y = "1"; // 已采集
    public final static String COLLECT_T = "2"; // 已推送（采集并推送）

    /************ 班次状态 ************/
    public final static String SHIFTSTATUS_WKS = "0"; // 未开始
    public final static String SHIFTSTATUS_ZXZ = "1"; // 执行中
    public final static String SHIFTSTATUS_YWC = "2"; // 已完成
    public final static String SHIFTSTATUS_YZT = "3"; // 已暂停

    /************ 任务人员投保标记 ************/
    public final static String TASKINSSIGN_WXTB = "0"; // 无需投保
    public final static String TASKINSSIGN_YTB = "1"; // 已投保
    public final static String TASKINSSIGN_WTB = "2"; // 未投保

    /************ 用户来源 ************/
    public final static String PERSOURCE_GADR = "1"; // 公安导入
    public final static String PERSOURCE_QYDR = "2"; // 企业导入
    public final static String PERSOURCE_ZZZC = "3"; // 自主注册
    public final static String PERSOURCE_YQMTJ = "4"; // 邀请码推荐
    public final static String PERSOURCE_QT = "9"; // 其他

    /************ 数据来源 ************/
    public final static String DATASOURCE_XTCS = "1"; // 系统产生
    public final static String DATASOURCE_SGDR = "2"; // 手工导入

    /************ 武装押运守护等级 ************/
    public final static String CONF_ARMEDLEVEL_YJ = "1"; // 一级
    public final static String CONF_ARMEDLEVEL_EJ = "2"; // 二级

    /************ 所属行业保安协会 ************/
    public final static String CONF_ASSOCIATION_ZGBAXH = "1"; // 中国保安协会
    public final static String CONF_ASSOCIATION_SBAXH = "2"; // 省保安协会
    public final static String CONF_ASSOCIATION_SHIBAXH = "3"; // 市保安协会

    /************ 人力防范等级 ************/
    public final static String CONF_MANPOWERLEVEL_YJ = "1"; // 一级
    public final static String CONF_MANPOWERLEVEL_EJ = "2"; // 二级
    public final static String CONF_MANPOWERLEVEL_SJ = "3"; // 三级

    /************ 风险评估等级 ************/
    public final static String CONF_RISKLEVEL_YJ = "1"; // 一级
    public final static String CONF_RISKLEVEL_EJ = "2"; // 二级

    /************ 安全范围 ************/
    public final static String CONF_SAFERANGE_MW = "1"; // 门卫
    public final static String CONF_SAFERANGE_XL = "2"; // 巡逻
    public final static String CONF_SAFERANGE_SH = "3"; // 守护
    public final static String CONF_SAFERANGE_SSHW = "4"; // 随身护卫
    public final static String CONF_SAFERANGE_YY = "5"; // 押运
    public final static String CONF_SAFERANGE_QYZXWH = "6"; // 区域秩序维护
    public final static String CONF_SAFERANGE_AQZX = "7"; // 安全咨询
    public final static String CONF_SAFERANGE_AQFXPG = "8"; // 安全风险评估
    public final static String CONF_SAFERANGE_AQJC = "9"; // 安全检查以及安全技术防范
    public final static String CONF_SAFERANGE_AQJSFF = "10"; // 安全技术防范

    /************ 安全技术防范等级 ************/
    public final static String CONF_SAFETECHLEVEL_YJ = "1"; // 一级
    public final static String CONF_SAFETECHLEVEL_EJ = "2"; // 二级
    public final static String CONF_SAFETECHLEVEL_SJ = "3"; // 三级

    /************ 角色组类型 ************/
    public final static String ROLEGROUPTYPE_MRJSZ = "1"; // 默认角色组
    public final static String ROLEGROUPTYPE_PTJSZ = "2"; // 普通角色组

    /************ 审批控件类型 ************/
    public final static String CONTROLTYPE_TEXT = "text"; // 单行输入框
    public final static String CONTROLTYPE_TEXTAREA = "textArea"; // 多行输入框
    public final static String CONTROLTYPE_DIGITAL = "digital "; // 数字输入框
    public final static String CONTROLTYPE_RADIO = "radio"; // 单选框
    public final static String CONTROLTYPE_CHECKBOX = "checkBox"; // 多选框
    public final static String CONTROLTYPE_DATE = "date"; // 日期
    public final static String CONTROLTYPE_DATESECTION = "dateSection"; // 日期区间
    public final static String CONTROLTYPE_IMG = "img"; // 图片
    public final static String CONTROLTYPE_DETAIL = "detail"; // 添加明细
    public final static String CONTROLTYPE_AMOUNT = "amount"; // 金额
    public final static String CONTROLTYPE_CONTENT = "content"; // 说明文字
    public final static String CONTROLTYPE_UPLOAD = "upload"; // 上传附件
    public final static String CONTROLTYPE_CONTACTS = "contacts"; // 联系人
    public final static String CONTROLTYPE_ADDRESS = "address"; // 地点定位
    public final static String CONTROLTYPE_FORMULA = "formula"; // 计算公式
    public final static String CONTROLTYPE_EXTERCONTACTS = "exterContacts"; // 外部联系人

    /************ 打卡归属 ************/
    public final static String CLOCKINONWER_KQDK = "1"; // 考勤打卡
    public final static String CLOCKINONWER_RWDK = "2"; // 任务打卡

    /************ 打卡类别 ************/
    public final static String CLOCKINTYPE_SBDK = "1"; // 上班打卡
    public final static String CLOCKINTYPE_XBDK = "2"; // 下班打卡

    /************ 打卡方式 ************/
    public final static String CLOCKINWAY_WIFI = "1"; // wifi打卡
    public final static String CLOCKINWAY_DDDK = "2"; // 地点打卡

    /************ 初始化流程类型 ************/
    public final static String INITPROCESSTYPE_CSMMXG = "1"; // 初始密码修改
    public final static String INITPROCESSTYPE_WSQYJCXX = "2"; // 完善企业基础信息
    public final static String INITPROCESSTYPE_WSRZXX = "3"; // 完善认证信息
    public final static String INITPROCESSTYPE_ZJBMJG = "4"; // 组建部门机构
    public final static String INITPROCESSTYPE_PZJSJQX = "5"; // 配置角色及权限
    public final static String INITPROCESSTYPE_DRYGJCXX = "6"; // 导入员工基础信息
    public final static String INITPROCESSTYPE_WSBXXX = "7"; // 完善保险信息

    /************ 可见类型 ************/
    public final static String VISIBLETYPE_QBKJ = "1"; // 全部可见
    public final static String VISIBLETYPE_BFKJ = "2"; // 部分可见

    /************ 审批组类型 ************/
    public final static String APPROVEGROUPTYPE_CQXJ = "1"; // 出勤休假
    public final static String APPROVEGROUPTYPE_RSSP = "2"; // 人事审批
    public final static String APPROVEGROUPTYPE_CWSP = "3"; // 财务审批
    public final static String APPROVEGROUPTYPE_XZSP = "4"; // 行政审批
    public final static String APPROVEGROUPTYPE_QTSP = "9"; // 其他审批
    public final static String APPROVEGROUPTYPE_YHZDYSP = "0"; // 用户自定义审批

    /************ 审批人去重规则 ************/
    public final static String DISTINCTRULE_BJXSPRQZ = "1"; // 不进行审批人去重
    public final static String DISTINCTRULE_DCDYC = "2"; // 审批人多次出现，仅保留第一次出现的审批环节
    public final static String DISTINCTRULE_DCZHYC = "3"; // 审批人多次出现，仅保留最后一次出现的审批环节
    public final static String DISTINCTRULE_QCDYC = "4"; // 在审批人连续出现时进行去重处理，仅保留第一次出现的审批环节

    /************ 通知抄送人规则 ************/
    public final static String NOTICECCRULE_JQBTYHTZ = "1"; // 仅全部同意后通知
    public final static String NOTICECCRULE_JFQSTZ = "2"; // 仅发起时通知
    public final static String NOTICECCRULE_FQSHQBTYHJTZ = "3"; // 发起时和全部同意后均通知

    /************ 接口操作类型 ************/
    public final static String INTERFACEOPERTYPE_READ = "read"; // 读
    public final static String INTERFACEOPERTYPE_WRITE = "write"; // 写

    /************ 是否完成 ************/
    public final static String ISCOMPLETE_S = "1"; // 是
    public final static String ISCOMPLETE_F = "0"; // 否

    /************ 业务类型 ************/
    public final static String BUSINESSTYPE_KQZXZ = "CA0001"; // 考勤组新增
    public final static String BUSINESSTYPE_KQZBJ = "CA0002"; // 考勤组编辑
    public final static String BUSINESSTYPE_KQZRYAP = "CA0003"; // 考勤组人员安排
    public final static String BUSINESSTYPE_KQLXSZ = "CA0004"; // 考勤类型设置
    public final static String BUSINESSTYPE_KQFSSZ = "CA0005"; // 考勤方式设置
    public final static String BUSINESSTYPE_KQZSC = "CA0006"; // 考勤组删除
    public final static String BUSINESSTYPE_KQZPBWH = "CA0007"; // 考勤组排班维护
    public final static String BUSINESSTYPE_QYZC = "CB0001"; // 企业注册
    public final static String BUSINESSTYPE_QYJBXXWH = "CB0002"; // 企业基本信息维护
    public final static String BUSINESSTYPE_QYRZXXWH = "CB0004"; // 企业认证信息维护
    public final static String BUSINESSTYPE_HTXZ = "CC0001"; // 合同新增
    public final static String BUSINESSTYPE_HTXG = "CC0002"; // 合同修改
    public final static String BUSINESSTYPE_HTSC = "CC0003"; // 合同删除
    public final static String BUSINESSTYPE_SBXZ = "CE0001"; // 设备新增
    public final static String BUSINESSTYPE_SBXG = "CE0002"; // 设备修改
    public final static String BUSINESSTYPE_SBSC = "CE0003"; // 设备删除
    public final static String BUSINESSTYPE_SBCKRK = "CE0004"; // 设备出库入库
    public final static String BUSINESSTYPE_QYFPXXXZ = "CI0001"; // 企业发票信息新增
    public final static String BUSINESSTYPE_QYFPXXWH = "CI0002"; // 企业发票信息维护
    public final static String BUSINESSTYPE_QYXXBXXZ = "CI0011"; // 企业线下保险新增
    public final static String BUSINESSTYPE_QYXXBXWH = "CI0012"; // 企业线下保险维护
    public final static String BUSINESSTYPE_QYZXBXGM = "CI0013"; // 企业在线保险购买
    public final static String BUSINESSTYPE_QYXXBXSC = "CI0014"; // 企业线下保险删除
    public final static String BUSINESSTYPE_QYJJFAXZ = "CI0021"; // 企业缴交方案新增
    public final static String BUSINESSTYPE_QYJJFAWH = "CI0022"; // 企业缴交方案维护
    public final static String BUSINESSTYPE_QYJJFASC = "CI0023"; // 企业缴交方案删除
    public final static String BUSINESSTYPE_FBZWXZ = "CJ0001"; // 发布职位新增
    public final static String BUSINESSTYPE_FBZWWH = "CJ0002"; // 发布职位维护
    public final static String BUSINESSTYPE_QYKQJYXZ = "CM0001"; // 企业跨区经营新增
    public final static String BUSINESSTYPE_QYKQJYWH = "CM0002"; // 企业跨区经营维护
    public final static String BUSINESSTYPE_QYKQJYSC = "CM0003"; // 企业跨区经营删除
    public final static String BUSINESSTYPE_QYHWJYXZ = "CM0004"; // 企业海外经营新增
    public final static String BUSINESSTYPE_QYHWJYWH = "CM0005"; // 企业海外经营维护
    public final static String BUSINESSTYPE_QYHWJYSC = "CM0006"; // 企业海外经营删除
    public final static String BUSINESSTYPE_QYGLCXZ = "CM0011"; // 企业管理层新增
    public final static String BUSINESSTYPE_QYGLCXXBG = "CM0012"; // 企业管理层信息变更
    public final static String BUSINESSTYPE_QYGLCSC = "CM0013"; // 企业管理层删除
    public final static String BUSINESSTYPE_QYZGLYBG = "CM0021"; // 企业主管理员变更
    public final static String BUSINESSTYPE_BMXZ = "CP0001"; // 部门新增
    public final static String BUSINESSTYPE_BMWH = "CP0002"; // 部门维护
    public final static String BUSINESSTYPE_BMSC = "CP0003"; // 部门删除
    public final static String BUSINESSTYPE_QYFGSXZ = "CP0010"; // 企业分公司新增
    public final static String BUSINESSTYPE_BBCJ = "CR0001"; // 报表创建
    public final static String BUSINESSTYPE_BBXG = "CR0002"; // 报表修改
    public final static String BUSINESSTYPE_BBSC = "CR0003"; // 报表删除
    public final static String BUSINESSTYPE_QYGDXZ = "CS0001"; // 企业股东新增
    public final static String BUSINESSTYPE_QYGDXXCSH = "CS0002"; // 企业股东信息初始化
    public final static String BUSINESSTYPE_QYGQBG = "CS0003"; // 企业股权变更
    public final static String BUSINESSTYPE_KQZBCXZ = "CS0011"; // 考勤组班次新增
    public final static String BUSINESSTYPE_KQZBCBJ = "CS0012"; // 考勤组班次编辑
    public final static String BUSINESSTYPE_KQZBCSC = "CS0013"; // 考勤组班次删除
    public final static String BUSINESSTYPE_RWXZ = "CT0001"; // 任务新增
    public final static String BUSINESSTYPE_RWJCXXWH = "CT0002"; // 任务基础信息维护
    public final static String BUSINESSTYPE_RWCQXXWH = "CT0003"; // 任务出勤信息维护
    public final static String BUSINESSTYPE_RWFBXXWH = "CT0004"; // 任务发布信息维护
    public final static String BUSINESSTYPE_RWRYPBWH = "CT0005"; // 任务人员排班维护
    public final static String BUSINESSTYPE_RWBCXZ = "CT0006"; // 任务班次新增
    public final static String BUSINESSTYPE_RWBCWH = "CT0007"; // 任务班次维护
    public final static String BUSINESSTYPE_RWBCSC = "CT0008"; // 任务班次删除
    public final static String BUSINESSTYPE_RWDAIB = "CT0009"; // 任务代班
    public final static String BUSINESSTYPE_RWDB = "CT0010"; // 任务代班
    public final static String BUSINESSTYPE_RWZY = "CT0011"; // 任务增援
    public final static String BUSINESSTYPE_RWQX = "CT0012"; // 任务取消
    public final static String BUSINESSTYPE_JLXXXZ = "PA0001"; // 奖励信息新增
    public final static String BUSINESSTYPE_RYXZ = "PA0002"; // 人员新增
    public final static String BUSINESSTYPE_PLRYDR = "PA0003"; // 批量人员导入
    public final static String BUSINESSTYPE_JLXXWH = "PA0012"; // 奖励信息维护
    public final static String BUSINESSTYPE_JLXXSC = "PA0013"; // 奖励信息删除
    public final static String BUSINESSTYPE_RYXXWH = "PB0001"; // 人员信息维护
    public final static String BUSINESSTYPE_RYZSXZ = "PC0001"; // 人员证书新增
    public final static String BUSINESSTYPE_RYZSWH = "PC0002"; // 人员证书维护
    public final static String BUSINESSTYPE_RYZSSC = "PC0003"; // 人员证书删除
    public final static String BUSINESSTYPE_HRHSXZ = "PG0001"; // 好人好事新增
    public final static String BUSINESSTYPE_HRHSWH = "PG0002"; // 好人好事维护
    public final static String BUSINESSTYPE_HRHSSC = "PG0003"; // 好人好事删除
    public final static String BUSINESSTYPE_RYLZ = "PL0001"; // 人员离职
    public final static String BUSINESSTYPE_PLRYLZ = "PL0002"; // 批量人员离职
    public final static String BUSINESSTYPE_CFXXXZ = "PP0001"; // 处罚信息新增
    public final static String BUSINESSTYPE_CFXXWH = "PP0002"; // 处罚信息维护
    public final static String BUSINESSTYPE_CFXXSC = "PP0003"; // 处罚信息删除
    public final static String BUSINESSTYPE_RYZC = "PR0001"; // 人员注册
    public final static String BUSINESSTYPE_RYBMDZ = "PT0001"; // 人员部门调整

    /************ App列表任务状态 ************/
    public final static String CURRENTTASKSTATUS_JXZ = "1"; // 正在执行
    public final static String CURRENTTASKSTATUS_YWC = "2"; // 已完成
    public final static String CURRENTTASKSTATUS_YJS = "3"; // 已结束
    public final static String CURRENTTASKSTATUS_XRW = "4"; // 新任务
    public final static String CURRENTTASKSTATUS_JJJX = "5"; // 即将进行
    /************ 打卡时限开关状态 ************/
    public final static String CLOCKLIMITSWITCHSTATUS_CLOSE = "0"; // 关闭
    public final static String CLOCKLIMITSWITCHSTATUS_OPEN = "1"; // 打开

    /************ App列表轮次状态 ************/
    public final static String SMALLSHIFTTYPE_YWC = "1"; // 已完成
    public final static String SMALLSHIFTTYPE_KQD = "2"; // 可签到
    public final static String SMALLSHIFTTYPE_KXB = "3"; // 可下班
    public final static String SMALLSHIFTTYPE_WKS = "4"; // 未开始

    /************ App值班状态（1正常2离岗） ************/
    public final static String DUTYSTATE_ZC = "1"; // 正常
    public final static String DUTYSTATE_LG = "2"; // 离岗

    /************ 预定义审批 ************/
    public final static String PREDEFINED_N = "0"; //否
    public final static String PREDEFINED_Y = "1"; //是

    /************ 审批状态 ************/
    public final static String APPROVESTATUS_SPZ = "0"; // 审批中
    public final static String APPROVESTATUS_SPTG = "1"; // 审批通过
    public final static String APPROVESTATUS_SPBTG = "2"; // 审批不通过
    public final static String APPROVESTATUS_YCX = "3"; //已撤销

    /************ activiti流转条件 ************/
    public final static String ACTIVITI_CONDITION_Y = "通过"; // 通过
    public final static String ACTIVITI_CONDITION_N = "不通过"; // 不通过

    /************ 审批动作 ************/
    public final static String APPROVALACTION_CX = "0"; //撤销
    public final static String APPROVALACTION_TY = "1"; //同意
    public final static String APPROVALACTION_BTY = "2"; //不同意

    /************ 补卡事项 ************/
    public final static String REMEDYMATTER_SBDK = "1"; //上班打卡
    public final static String REMEDYMATTER_XBDK = "2"; //下班打卡

    /************ 请假类型 ************/
    public final static String LEAVETYPE_SJ = "1"; //事假
    public final static String LEAVETYPE_BJ = "2"; //病假
    public final static String LEAVETYPE_NJ = "3"; //年假
    public final static String LEAVETYPE_HJ = "4"; //婚假
    public final static String LEAVETYPE_TX = "5"; //调休
    public final static String LEAVETYPE_CJ = "6"; //产假
    public final static String LEAVETYPE_GJ = "7"; //公假
    public final static String LEAVETYPE_ZGJ = "8"; //主管假


    /************ 固定审批类型 ************/
    public final static String APPROVETYPE_KQQJ = "11"; //考勤请假
    public final static String APPROVETYPE_CC = "12"; //出差
    public final static String APPROVETYPE_WC = "13"; //外出
    public final static String APPROVETYPE_JB = "14"; //加班
    public final static String APPROVETYPE_KQBK = "15"; //考勤补卡
    public final static String APPROVETYPE_ZZ = "21"; //转正
    public final static String APPROVETYPE_ZP = "22"; //招聘
    public final static String APPROVETYPE_BX = "31"; //报销
    public final static String APPROVETYPE_BYJSQ = "32"; //备用金申请
    public final static String APPROVETYPE_FKSQ = "33"; //付款申请
    public final static String APPROVETYPE_YCSQ = "41"; //用车申请
    public final static String APPROVETYPE_WPLY = "42"; //物品领用
    public final static String APPROVETYPE_YYSQ = "43"; //用印申请
    public final static String APPROVETYPE_TYSP = "44"; //通用审批
    public final static String APPROVETYPE_RWQJ = "51"; //任务请假
    public final static String APPROVETYPE_RWBK = "52"; //任务补卡
    public final static String APPROVETYPE_WQDB = "53"; //外勤代班
    public final static String APPROVETYPE_CG = "91"; //采购
    public final static String APPROVETYPE_JXZP = "92"; //绩效自评
    public final static String APPROVETYPE_HTSP = "93"; //合同审批
    public final static String APPROVETYPE_LXSQ = "94"; //立项申请
    public final static String APPROVETYPE_DGSQD = "95"; //调岗申请单
    public final static String APPROVETYPE_LZSQD = "96"; //离职申请单
    public final static String APPROVETYPE_HB = "97"; //换班

    /************ 审批列表查询类型 ************/

    public final static String APPROVELISTQUERYTYPE_WSQ = "1"; //　我申请的
    public final static String APPROVELISTQUERYTYPE_YSP = "2"; //　我已审批的
    public final static String APPROVELISTQUERYTYPE_DSP = "3"; // 待我审批的
    public final static String APPROVELISTQUERYTYPE_CSW = "4"; // 抄送我的

    /************ 加班类型 ************/
    public final static String OVERTYPE_GZRJB = "1"; //工作日加班
    public final static String OVERTYPE_XXRJB = "2"; //休息日加班
    public final static String OVERTYPE_JJRJB = "3"; //节假日加班

    /************ 考勤统计维度 ************/
    public final static String COUNTDIMENSION_BZ = "1"; //本周
    public final static String COUNTDIMENSION_SZ = "2"; //上周
    public final static String COUNTDIMENSION_BY = "3"; //本月
    public final static String COUNTDIMENSION_SY = "4"; //上月

    /************ 证书类型 ************/
    public final static String PERCERTYPE_DJ = "010001"; //保安员等级证
    public final static String PERCERTYPE_ZG = "010002"; //保安员资格证
    public final static String PERCERTYPE_CQ= "010003"; //持枪证
    public final static String PERCERTYPE_DJJYZ= "010004"; //保安员等级结业证

    /************ app市场类型 ************/
    public final static String APPMARKETTYPE_ALL = "1"; //全国市场
    public final static String APPMARKETTYPE_OTHER = "2"; //排除北京市场
    public final static String APPMARKETTYPE_BJ= "3"; //北京市场

    public final static String SMSCODE_P01 = "P01";
    public final static String SMSCODE_B01 = "B01";
    public final static String SMSCODE_B02 = "B02";
    public final static String SMSCODE_B03 = "B03";
    public final static String SMSCODE_B04 = "B04";
    public final static String SMSCODE_B05 = "B05";
    public final static String SMSCODE_B06 = "B06";
    public final static String SMSCODE_B07 = "B07";
    public final static String SMSCODE_B08 = "B08";
    public final static String SMSCODE_B09 = "B09";
    public final static String SMSCODE_B11 = "B11";
    public final static String SMSCODE_B13 = "B13";
    /**
     * 公共服务安全平台服务状态变更，应用：{}，状态：{}
     */
    public final static String SMSCODE_B78 = "B78";


    /************ 是否在职 ************/
    public final static String INCUMBENCY_Y = "1"; //在职
    public final static String INCUMBENCY_N = "0"; //离职

    /************ 保全类型 ************/
    public final static String PERSERVATION_ZY = "1"; //增员
    public final static String PERSERVATION_JY = "2"; //减员

    /************ 设备类型编码 ************/
    public final static String MOBILEDEVICETYPE_NULL = "0"; //未知
    public final static String MOBILEDEVICETYPE_ANDROID = "1"; //安卓
    public final static String MOBILEDEVICETYPE_IOS = "2"; //苹果

    /************ 提交记录码 ************/
    public final static String COMMIT_NY = "0"; //未提交记录（有暂存）
    public final static String COMMIT_YY = "1"; //已提交记录（有暂存）
    public final static String COMMIT_NN = "2"; //无记录（无暂存）

    /************ 审批状态码(百保盾状态码) ************/
    public final static String STATUSCODE_WSP = "000"; //无审批(saas业务需要产生的状态码)
    public final static String STATUSCODE_DSP = "002"; //待审批
    public final static String STATUSCODE_SPTG = "003"; //审批通过
    public final static String STATUSCODE_SPBTG = "004"; //审批不通过
    public final static String STATUSCODE_SPZ = "005"; //审批中


    /************ 驻勤点类型 ************/

    public final static String TASKSTATIONTYPE_DZJG = "01"; //党政机关
    public final static String TASKSTATIONTYPE_GDYX = "02"; //高等院校
    public final static String TASKSTATIONTYPE_GJAQ = "03"; //公交安全
    public final static String TASKSTATIONTYPE_GYJD = "04"; //公园景点
    public final static String TASKSTATIONTYPE_GDJT = "05"; //轨道交通
    public final static String TASKSTATIONTYPE_JR = "06"; //金融
    public final static String TASKSTATIONTYPE_JDCY = "07"; //酒店餐饮
    public final static String TASKSTATIONTYPE_JMSQ = "08"; //居民社区
    public final static String TASKSTATIONTYPE_QSYDW = "09"; //企事业单位
    public final static String TASKSTATIONTYPE_SSC = "10"; //商市场
    public final static String TASKSTATIONTYPE_YLJG = "11"; //医疗机构
    public final static String TASKSTATIONTYPE_YLCS = "12"; //娱乐场所
    public final static String TASKSTATIONTYPE_WHTY = "13"; //文化/体育/会展中心
    public final static String TASKSTATIONTYPE_YQ = "14"; //园区
    public final static String TASKSTATIONTYPE_XZJD = "15"; //乡镇街道
    public final static String TASKSTATIONTYPE_ZXXYEY = "16"; //中小学幼儿园

    /************ 交易状态 ************/
    public final static String TRADESTATUS_DJY = "0"; //待交易
    public final static String TRADESTATUS_JYCG = "1"; //交易成功
    public final static String TRADESTATUS_JYSB = "2"; //交易失败

    /************ 交易类型 ************/
    public final static String TRADETYPE_QYZHCZ = "01"; //企业账户充值
    public final static String TRADETYPE_QYZHTX = "02"; //企业账户提现
    public final static String TRADETYPE_QYZHZF = "03"; //企业账户支付
    public final static String TRADETYPE_QYZHDJ = "04"; //企业账户金额冻结
    public final static String TRADETYPE_QYZHJD = "05"; //企业账户金额解冻
    public final static String TRADETYPE_GRZHCZ = "11"; //个人账户充值
    public final static String TRADETYPE_GRZHTX = "12"; //个人账户提现
    public final static String TRADETYPE_GRZHDJ = "13"; //个人账户金额冻结
    public final static String TRADETYPE_GRZHJD = "14"; //个人账户金额解冻

    /************ 操作发放功能类型 ************/
    public final static String OPERGRANTFUNCTYPE_XJFFXX = "1"; //新建发放信息
    public final static String OPERGRANTFUNCTYPE_TXRYKT = "2"; //提醒人员开通
    public final static String OPERGRANTFUNCTYPE_FFXZ = "3"; //发放薪资
    public final static String OPERGRANTFUNCTYPE_DCFFSJ = "4"; //导出发放数据
    public final static String OPERGRANTFUNCTYPE_DRXXSJ = "5"; //添加数据
    public final static String OPERGRANTFUNCTYPE_TJFFSQ = "6"; //提交发放申请

    /************ 发放类型 ************/
    public final static String GRANTTYPE_FFDQB = "1"; //发放到钱包
    public final static String GRANTTYPE_FFDYXK = "2"; //发放到银行卡
    public final static String GRANTTYPE_FFDBAYZLMK = "3"; //发放到保安员证联名卡

    /************ 发放数据来源 ************/
    public final static String GRANTDATASOURCE_YYXCHS = "1"; //引用薪酬核算
    public final static String GRANTDATASOURCE_DRXXSJ = "2"; //导入线下数据
    public final static String GRANTDATASOURCE_YYXCFW = "3"; //引用薪酬服务

    /************ 总体发放状态 ************/
    public final static String ALLGRANTSTATUS_DFF = "0"; //待发放
    public final static String ALLGRANTSTATUS_ZZFF = "1"; //正在发放，一提交
    public final static String ALLGRANTSTATUS_BFWC = "2"; //部分完成，待发n，失败n
    public final static String ALLGRANTSTATUS_QBWC = "3"; //全部完成，待发0，失败0

    /************ 发放状态 ************/
    public final static String GRANTSTATUS_DFF = "0"; //待发放
    public final static String GRANTSTATUS_FFCG = "1"; //发放成功
    public final static String GRANTSTATUS_FFSB = "2"; //发放失败

    /************ 处理状态 ************/
    public final static String PROCESSSTATUS_CLZ = "0"; // 处理中
    public final static String PROCESSSTATUS_YCL = "1"; // 已处理

    /************ 限制查看App通讯录类型 ************/
    public final static String LIMITSEEAPPTYPE_ZNKDZJ = "1"; //只能看到自己
    public final static String LIMITSEEAPPTYPE_ZNKDSZBMRY = "2"; //只能看到所在部门人员
    public final static String LIMITSEEAPPTYPE_ZNKDSZBMJYXBMRY = "3"; //只能看到所在部门及以下部门人员
    public final static String LIMITSEEAPPTYPE_ZNKDTDBM = "4"; //只能看到特定部门

    /************ 平台类型 ************/
    public final static String CLIENTTYPE_APP  =  "saasmobile";
    public final static String CLIENTTYPE_WEB  =  "saasweb";

    /************ 是否通知保安人员 0不通知1通知 ************/
    public final static String NOTICEPERSON_N = "0"; //不通知
    public final static String NOTICEPERSON_Y = "1"; //通知

    /************ 公安级别 ************/
    public final static String POLICELEVEL_SF = "1"; // 公安厅
    public final static String POLICELEVEL_DS = "2"; // 地市公安局
    public final static String POLICELEVEL_QX = "3"; // 区县公安局
    public final static String POLICELEVEL_PCS = "4"; // 派出所


    /************ 手机系统类型 ************/
    public final static String OSTYPE_IOS = "1"; // ios
    public final static String OSTYPE_ANDROID = "2"; // android

    /************ 钱包修改类型 ************/
    public final static String COMWALLETCHANGETYPE_CARD = "1"; // 修改银行卡

    /************ 极光推送类型 ************/
    public final static String JP_TYPE_MSG = "1"; // 常规消息推送
    public final static String JP_TYPE_SP = "2"; // 视频房间信息推送


    /************ 百课堂课程类型 ************/
    public final static String BKTTRACKTYPE_BAYDJZKC = "3"; // 保安员等级证课程
    public final static String BKTTRACKTYPE_GQPXKC = "4"; // 岗前培训课程

    /************* 人员类型 *************/
    public final static String PERSONTYPE_WGRY = "1"; // 外省市来京务工人员
    public final static String PERSONTYPE_SYRY = "2"; // 本市登记失业人员
    public final static String PERSONTYPE_LDL = "3"; // 本市农村转移就业劳动力
    public final static String PERSONTYPE_GXBYS = "4"; // 本市应届高校毕业生
    public final static String PERSONTYPE_FYJRTYSB = "5"; // 本市复员专业军人-退役士兵
    public final static String PERSONTYPE_FYJRFYGB = "6"; // 本市复员专业军人-复员干部
    public final static String PERSONTYPE_FYJRZYGB = "7"; // 本市复员专业军人-专业干部
    public final static String PERSONTYPE_TYJR = "8"; // 退役军人（概括前面的567）
    public final static String PERSONTYPE_PTBAY = "9"; // 普通保安员（概括前面的1234）

    /************* 户籍类型 *************/
    public final static String HOUSEHOLDTYPE_NC = "1"; // 农村
    public final static String HOUSEHOLDTYPE_CZ = "2"; // 城镇

    /************* 户籍所在地类型 *************/
    public final static String HOUSEHOLDADDRESSTYPE_BS = "1"; // 本市
    public final static String HOUSEHOLDADDRESSTYPE_WB = "2"; // 外埠

    /************ 实习状态 ************/
    public final static String INTERNSTATUS_SXZ = "0";//实习中
    public final static String INTERNSTATUS_SXWC = "1";//实习完成

    /************* 监管类型 *************/
    public final static String REGULATORTYPE_ZCD = "1"; // 注册地监管
    public final static String REGULATORTYPE_BGD = "2"; // 办公地监管

    /************ 投保状态 ************/
    public final static String INSUREDSTATES_BZB = "0"; // 不在保
    public final static String INSUREDSTATES_ZB = "1"; // 在保

    /************ 发放方式 ************/
    public final static String GRANTMODE_YHZZ = "1"; // 银行转账
    public final static String GRANTMODE_XJ = "2"; // 现金

    /************ 发放渠道 ************/
    public final static String GRANTCHANNEL_ZXFF = "1"; // 在线发放
    public final static String GRANTCHANNEL_XXFF = "2"; // 线下发放

    /************ 课程产品类型 ************/
    public final static String COURSETYPE_BAZGZ = "1"; //保安资格证课程
    public final static String COURSETYPE_JXZJY = "2"; //继续再教育课程
    public final static String COURSETYPE_BADJZ  ="3"; //保安等级证课程
    public final static String COURSETYPE_GQPX  ="4"; //岗前培训课程
    public final static String COURSETYPE_GWSYX  ="5"; //岗位适应性课程
    public final static String COURSETYPE_QT  ="9"; //其他

    /************ 媒体形式 ************/
    public final static String MEDIATYPE_VIDEO = "1"; //视频
    public final static String MEDIATYPE_QUESTION = "2"; //试题

    /************ 任务有效性 ************/
    public final static String TASKEFFECT_WSX = "0"; // 未生效
    public final static String TASKEFFECT_YSX = "1"; // 已生效
    public final static String TASKEFFECT_ZZ = "2"; // 终止

    /************ 考试方式 ************/
    public final static String EXAMWAY_OFFLINE = "1"; // 线下
    public final static String EXAMWAY_WEB = "2"; // web
    public final static String EXAMWAY_APP = "3"; // app
    public final static String EXAMWAY_BBD = "4"; // 百保盾

    /************ 考试科目 ************/
    public final static String EXAMSUBJECT_ZGZ = "1"; // 资格证
    public final static String EXAMSUBJECT_DJZ = "2"; // 等级证

    /************ 题目类型 ************/
    public final static String QUESTIONTYPE_RADIO = "1"; // 单选
    public final static String QUESTIONTYPE_CHECKBOX = "2"; // 多选
    public final static String QUESTIONTYPE_JUDGE = "3"; // 判断

    /************ 签到状态 ************/
    public final static String INTERNSTEP_QD = "1";//签到
    public final static String INTERNSTEP_QT = "2";//签退
    public final static String INTERNSTEP_WC = "3";//完成


    /************ 审核状态（材料核对） ************/
    public final static String APPROVALSTATUS_DSH = "0";//未审核
    public final static String APPROVALSTATUS_SHTG = "1";//审核通过
    public final static String APPROVALSTATUS_SHBTG = "2";//审核不通过

    /************ 申报状态************/
    public final static String APPLYSTATUS_DSH = "0";//申报中
    public final static String APPLYSTATUS_SHTG = "1";//申报通过
    public final static String APPLYSTATUS_SHBTG = "2";//申报不通过
    public final static String APPLYSTATUS_CX = "3";//申报撤销

    /* 背景筛查状态 */
    public final static String BACKGROUNDSTATUS_SHZ = "0";//审核中
    public final static String BACKGROUNDSTATUS_ZC = "1";//正常
    public final static String BACKGROUNDSTATUS_GZ = "2";//关注
    public final static String BACKGROUNDSTATUS_SQTG = "3";//申诉通过
    public final static String BACKGROUNDSTATUS_SQBTG = "4";//申诉不通过
    public final static String BACKGROUNDSTATUS_SQZ = "5";//申诉中

    /* 等级证*/
    public final static String GRADELEVEL_ONE = "1";

    /************ 审核不通过的原因************/
    public final static String APPROVEFAIL_BJBTG = "背景筛查申诉失败";
    public final static String APPROVEFAIL_CXBM = "报名方撤销报名";
    public final static String APPROVEFAIL_CLBTG = "报名材料核对不通过";
    public final static String APPROVEFAIL_KSBTG = "鉴定考试不通过";

    /************ 参会状态：0.拒绝；1.接受；2.录制；9.未响应 ************/
    public final static String ATTENDEXPOSTATUS_JJ = "0";//拒绝
    public final static String ATTENDEXPOSTATUS_JS = "1";//接受
    public final static String ATTENDEXPOSTATUS_LZ = "2";//录制
    public final static String ATTENDEXPOSTATUS_WXY = "9";//未响应

    /************ 人员APP菜单 ************/
    public final static String CONFIGPERAPPMENU_WDQB = "10";// 我的钱包
    public final static String CONFIGPERAPPMENU_BAYLMK = "11";// 保安员证联名卡
    public final static String CONFIGPERAPPMENU_SQLP = "12";//录制

    /************ 补贴类型 ************/
    public final static String SUBSIDYTYPE_BAYZGZKWBT = "1";// 保安员资格证考务补贴
    public final static String SUBSIDYTYPE_ZYJNPXBT = "2";// 职业技能培训补贴

    /************ 优惠方式 ************/
    public final static String DISCOUNTWAY_YHGDJE = "1";// 优惠固定金额
    public final static String DISCOUNTWAY_YHDGDJE = "2";// 优惠到固定金额
    public final static String DISCOUNTWAY_YHBL = "3";// 优惠比例

    /************ 优惠券状态 ************/
    public final static String COUPONSTATUS_WSY = "0";// 未使用
    public final static String COUPONSTATUS_YSY = "1";// 已使用
    public final static String COUPONSTATUS_YGQ = "2";// 已过期

    /************采购状态************/
    public final static String PURCHASE_STATUS_WXD = "0" ;  // 未下单
    public final static String PURCHASE_STATUS_WZF = "1" ;  // 未支付
    public final static String PURCHASE_STATUS_YZF = "2" ;  // 已支付

    /************分配状态************/
    public final static String ORDER_DEPLOY_STATUS_Y = "1" ;  // 已分配
    public final static String ORDER_DEPLOY_STATUS_N = "0" ;  // 未分配


    /************上下班打卡类型************/
    public final static String CLOCKTYPE_SB = "1" ;  // 上班
    public final static String CLOCKTYPE_XB = "2" ;  // 下班
    /************打卡类型************/
    public final static String CLOCKTYPE_POSITION = "0" ;  // 定位
    public final static String CLOCKTYPE_WIFI = "1" ;  // wifi

    /************打卡数据来源类型************/
    public final static String CLOCKSOURCE_DK = "1" ;  // 打卡
    public final static String CLOCKSOURCE_BK = "2" ;  // 补卡
    public final static String CLOCKSOURCE_SDBK = "3" ;  // 手动补卡

    /************考勤打卡报表类型************/
    public final static String ATTENDREPORTTYPE_DAY = "1" ;  // 日结果
    public final static String ATTENDREPORTTYPE_MONTH = "2" ;  // 月结果

    /************考勤打卡报表结果状态 0异常1正常2缺卡3迟到4早退5缺勤34迟到早退************/
    public final static String ATTENDRESULTSTATUS_0 = "0" ;  // 异常
    public final static String ATTENDRESULTSTATUS_1 = "1" ;  // 正常
    //public final static String ATTENDRESULTSTATUS_2 = "2" ;  // 缺卡
    //public final static String ATTENDRESULTSTATUS_3 = "3" ;  // 迟到
    //public final static String ATTENDRESULTSTATUS_4 = "4" ;  // 早退
    //public final static String ATTENDRESULTSTATUS_5 = "5" ;  // 缺勤
    //public final static String ATTENDRESULTSTATUS_34 = "34" ;  // 迟到早退


    /************考勤打卡状态 1正常2缺卡3迟到4早退5缺勤6补卡11请假21上班缺卡22下班缺卡23上班迟到下班缺卡24上班缺卡下班早退34迟到早退************/
    public final static String CLOCKSTATUS_1 = "1" ;  // 正常
    //public final static String CLOCKSTATUS_11 = "11" ;  // 请假
    //public final static String CLOCKSTATUS_2 = "2" ;  // 缺卡
    public final static String CLOCKSTATUS_21 = "21" ;  // 上班缺卡
    public final static String CLOCKSTATUS_22 = "22" ;  // 下班缺卡
    public final static String CLOCKSTATUS_23 = "23" ;  // 上班迟到下班缺卡
    public final static String CLOCKSTATUS_24 = "24" ;  // 上班缺卡下班早退
    public final static String CLOCKSTATUS_3 = "3" ;  // 迟到
    public final static String CLOCKSTATUS_4 = "4" ;  // 早退
    public final static String CLOCKSTATUS_5 = "5" ;  // 缺勤
    public final static String CLOCKSTATUS_34 = "34" ;  // 迟到早退

    /**
     * OA审批类型 0请假1加班2公出3出差4补卡
     */
    public final static String OA_DICTTYPE_0 = "0" ;  // 请假
    public final static String OA_DICTTYPE_1 = "1" ;  // 加班
    public final static String OA_DICTTYPE_2 = "2" ;  // 公出
    public final static String OA_DICTTYPE_3 = "3" ;  // 出差
    public final static String OA_DICTTYPE_4 = "4" ;  // 补卡

    public static final String APPLYSTATUS_TG_CH = "审批通过";


    /**
     * 补卡审批状态
     */
    public final static String CARDAPPLYSTATUS_11 = "11" ; // 请假
    public final static String CARDAPPLYSTATUS_6 = "6" ;   // 补卡审批中
    public final static String CARDAPPLYSTATUS_61 = "61" ; // 补卡通过

}

