package com.bcxin.platform.util.http;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.util.HttpUtils;
import com.google.common.collect.Lists;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

import java.util.List;

/**
 * <p>
 * 陈堂君
 * <p>
 * 类描述: 发送短信的工具类
 * <p>
 *
 * @apiNote 作者 陈堂君
 * @since 创建于 2017/12/19 21:50
 */
public class SMSUtil {

	public static Result send(String phone, String msg) {
		String url = "http://msg.bcxin.com.cn:9165/sms/sendMessage";
		String key = "bcxinABCXIN$1012 "; // key //PSS -pss 百宝盾 - ars 百联宝 coins
		String requestId = System.currentTimeMillis() + "";// 开始时间
		String type = "ars_saas";
		JSONObject json = new JSONObject();
		json.put("type", type);
		json.put("content", msg);// 内容
		json.put("mobile", phone);// 手机号码
		json.put("requestId", requestId);
		json.put("token", MD5Util.string2MD5(requestId + type + key));// 秘钥
		JSONObject retJson = null;
		try {
			String ret = RequestUtil.initHttp().doPost(url, json.toString(), "application/json", "UTF-8");
			retJson = JSONUtil.parseObj(ret);
			return Result.success("短信发送成功", retJson);
		} catch (Exception ex) {
			return Result.fail("短信发送失败", retJson);
		}
	}

	/**
	 * 发送华为短信
	 *
	 * @param huaWeiSmsContent
	 * @return
	 */
	public static Result sendHuaWeiSMS(HuaWeiSmsContent huaWeiSmsContent) {
		String url = "http://msg.bcxin.com.cn:9165/sms/huawei/sendSMS";
		List<NameValuePair> params = Lists.newArrayList();
		params.add(new BasicNameValuePair("data", JSON.toJSONString(huaWeiSmsContent)));
		params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN" + huaWeiSmsContent.getMobile() + DateUtil.today())));
		HttpUtils.doPost(url, params);
		return Result.success("短信发送成功");
	}

	public static void main(String[] args) {
		HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
		huaWeiSmsContent.setChannel("com");
		huaWeiSmsContent.setPlatform("V5");
		huaWeiSmsContent.setSmsCode("B00");
		huaWeiSmsContent.setMobile("18965192886");
		huaWeiSmsContent.setParams(JSON.toJSONString(new String[]{"123456"}));
		SMSUtil.sendHuaWeiSMS(huaWeiSmsContent);

	}
}
