package com.bcxin.platform.util.constants;

/**
 * 华为云会议相关接口地址
 *
 * @author llc
 * @date 2019-12-10
 */
public final class HuaweiMeetConst {

    public final static int HUAWEI_SUCCESS_CODE = 200;


    public final static String GATEWAY_URL = "https://api.meeting.huaweicloud.com";
    public final static String GATEWAY_BSS_URL = "https://bss.myhuaweicloud.com";
    /*** IAM登陆鉴权的专用地址 ***/
    public final static String GATEWAY_IAM_TOKENS_URL = "https://iam.myhuaweicloud.com/v3/auth/tokens";

    /*** IAM鉴权token获取报文，里面包含可替换参数：用户名为“IAMUser”，密码为“IAMPassword”，所属账号名为“IAMDomain” ***/
    public final static String REQUEST_IAM_TOKEN_MESSAGE = "{\"auth\":{\"identity\":{\"methods\":[\"password\"],\"password\":{\"user\":{\"domain\":{\"name\":\"IAMDomain\"},\"name\":\"IAMUser\",\"password\":\"IAMPassword\"}}},\"scope\":{\"project\":{\"name\":\"IAMproject\"}}}}";


    /***---------------------个人相关---------------------***/

    /*** 登陆鉴权 ***/
    public final static String GET_ACCESSTOKEN = "/v1/usg/acs/auth/account";


    /*** 新增用户 ***/
    public final static String ADD_USER = "/v1/usg/dcs/corp/member";


    /*** 批量删除用户 ***/
    public final static String BATCH_DELETE_USER = "/v1/usg/dcs/corp/member/delete";


    /*** 查询会议列表 ***/
    public final static String GET_MEET_LIST = "/v1/mmc/management/conferences";

    /*** 查询会议详情 ***/
    public final static String GET_MEET_DETAIL = "/v1/mmc/management/conferences/confDetail";

    /*** 预约会议 ***/
    public final static String ADD_MEET = "/v1/mmc/management/conferences";

    /*** 用户查询自己的信息 ***/
    public final static String GET_USER_DETAIL = "/v1/usg/dcs/member";


    /*** 查询录播文件列表 ***/
    public final static String GET_TRANSCRIBE_FILE_LIST = "/v1/mmc/management/record/files";

    /*** 删除录播文件 ***/
    public final static String DELETE_TRANSCRIBE_FILE = "/v1/mmc/management/record/files";

    /*** 修改用户云会议室 ***/
    public final static String UPDATE_MEMBER_VMR = "/v1/usg/dcs/member/vmr/";

    /*** 回收专用云会议室 ***/
    public final static String RECYCLE_FROM_MEMBER = "/v1/usg/dcs/corp/vmr/recycle-from-member/";

    /*** 分配专用云会议室 ***/
    public final static String ASSIGN_TO_MEMBER = "/v1/usg/dcs/corp/vmr/assign-to-member/";

    /*** 删除专用云会议室 ***/
    public final static String DELETE_MEMBER_VMR = "/v1/usg/dcs/corp/vmr/delete";

    /*** 分页查询用户云会议室 ***/
    public final static String GET_MEMBER_VMR_LIST = "/v1/usg/dcs/member/vmr";


    /***---------------------企业相关---------------------***/

    /*** 获取企业管理资源 ***/
    public final static String GET_MANAGE_RESOURCE = "/v1/usg/dcs/corp/resource";

    /*** 分页查询专用云会议室 ***/
    public final static String GET_CLOUD_MEET_ROOM_LIST = "/v1/usg/dcs/corp/vmr";

    /*** SP管理员创建企业 ***/
    public final static String BUILD_CORP = "/v1/usg/dcs/sp/corp";

    /*** 采购资源 ***/
    public final static String PURCHASING_RESOURCE = "/v2/mbc/reasource";

    /*** 支付包周期产品订单 ***/
    public final static String ORDER_PAY = "/v1.0/{domain_id}/customer/order-mgr/order/pay";

    /*** 分页查询企业资源 ***/
    public final static String GET_RESOURCE_LIST = "/v1/usg/dcs/sp/corp/{corpId}/resource";

    /*** 删除企业资源 ***/
    public final static String DELETE_RESOURCE_LIST = "/v1/usg/dcs/sp/corp/{corpId}/resource/delete";

    /*** SP管理删除企业 ***/
    public final static String DEL_CORP = "/v1/usg/dcs/sp/corp/{corpId}";
}