package com.bcxin.platform.service.company.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.dto.company.ComBaseInfoDto;
import com.bcxin.platform.dto.company.ComDTO;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.service.company.ComBaseInfoService;
import com.bcxin.platform.util.ObjectUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 企业基础信息Service业务层处理
 * 
 * @author lin
 * @date 2021-04-09
 */
@Service
public class ComBaseInfoServiceImpl implements ComBaseInfoService {

    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询企业基础信息
     * 
     * @param comId 企业基础信息ID
     * @return 企业基础信息
     */
    @Override
    public ComBaseInfo selectComBaseInfoById(Long comId){
        return comBaseInfoMapper.selectComBaseInfoById(comId);
    }

    /**
     * 查询企业基础信息列表
     * 
     * @param comBaseInfo 企业基础信息
     * @return 企业基础信息
     */
    @Override
    public List<ComBaseInfo> selectComBaseInfoList(ComBaseInfo comBaseInfo){
        return comBaseInfoMapper.selectComBaseInfoList(comBaseInfo);
    }

    /**
     * 新增企业基础信息
     * 
     * @param comBaseInfo 企业基础信息
     * @return 结果
     */
    @Override
    public int insertComBaseInfo(ComBaseInfo comBaseInfo){
        comBaseInfo.setComId(idWorker.nextId());
        comBaseInfo.setCreateTime(DateUtils.getNowDate());
        return comBaseInfoMapper.insertComBaseInfo(comBaseInfo);
    }

    /**
     * 新增修改企业基础信息
     * 
     * @param comBaseInfo 企业基础信息
     * @return 结果
     */
    @Override
    public int updateComBaseInfo(ComBaseInfo comBaseInfo){
        ComBaseInfo dbComBaseInfo = comBaseInfoMapper.selectComBaseInfoByTlkId(comBaseInfo.getTlkComId());
        if(dbComBaseInfo == null){
            comBaseInfo.setComId(idWorker.nextId());
            comBaseInfo.setCreateTime(DateUtils.getNowDate());
            return comBaseInfoMapper.insertComBaseInfo(comBaseInfo);
        }else {
            comBaseInfo.setUpdateTime(DateUtils.getNowDate());
            return comBaseInfoMapper.updateComBaseInfo(comBaseInfo);
        }
    }

    /**
     * 删除企业基础信息对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteComBaseInfoByIds(String ids){
        return comBaseInfoMapper.deleteComBaseInfoByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除企业基础信息信息
     * 
     * @param comId 企业基础信息ID
     * @return 结果
     */
    @Override
    public int deleteComBaseInfoById(Long comId){
        return comBaseInfoMapper.deleteComBaseInfoById(comId);
    }

    @Override
    public Result getByPrimaryKey(ComBaseInfoDto comBaseInfoDto) {
        long a = System.currentTimeMillis();
        ComBaseInfo comBaseInfo = comBaseInfoMapper.selectComBaseInfoById(comBaseInfoDto.getComId());
        /*** 需排除离职人员 ***/
        if (comBaseInfo != null) {
            ObjectUtils.copyProperties(comBaseInfoDto, comBaseInfo);
        }
        return Result.success(Result.SUCCESS_QUERY_MSG, comBaseInfoDto);
    }

    @Override
    public ComBaseInfo selectComBaseInfoByTlkId(String tklComId) {
        return comBaseInfoMapper.selectComBaseInfoByTlkId(tklComId);
    }

    @Override
    public ComDTO selectByID(ComDTO dto) {
        return comBaseInfoMapper.selectDetialByID(dto.getComId());
    }

    /**
     * <b> 企业下拉分页 </b>
     * @author ZXF
     * @create 2021/06/25 0025 10:44
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map> queryCompanyCombobox() {
        return comBaseInfoMapper.queryCompanyCombobox();
    }
}
