package com.bcxin.platform.service.blb;

import cn.hutool.http.HttpUtil;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.util.HttpUtils;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.codes.BLBServiceConst;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 * <b> 百联保联调 </b>
 * @author ZXF
 * @create 2020/03/20 0020 16:43
 * @version
 * @注意事项 </b>
 */
@Service
@Transactional("transactionManager")
public class BlbTestServiceImpl implements BlbTestService {
    private static Logger logger = LoggerFactory.getLogger(BlbTestServiceImpl.class);
    @Resource
    private CommonService commonService;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;

    /**
     * 获取当前请求对象
     *
     * @return
     */
    public HttpServletRequest getRequest() {
        try {
            return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * <b> 做增员保全 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result blbAddPreservationService(String comId, String orderId, String listStr, String inceptionDate){
        Map postParams = Maps.newHashMap();
        String platformSign = commonService.getSystemConfig("PLATFORM_SIGN");
        postParams.put("user_id", comId);
        postParams.put("party", platformSign);
        postParams.put("listStr", listStr);
        postParams.put("order_id", orderId);
        postParams.put("inception_date", inceptionDate);
        return HttpUtils.sendHttpRt(
                commonService.getSystemConfig("BLB_URL").replace("https:","http:") + BLBServiceConst.BLB_ADD_PRESERVATION_URL
                        + "?ACCESS_TOKEN=" + getToken()
                , postParams);
    }

    /**
     * <b> 做减员保全 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result blbMinusPreservationService(String comId, String orderId, String listStr,String inceptionDate){
        Map postParams = Maps.newHashMap();
        String platformSign = commonService.getSystemConfig("PLATFORM_SIGN");
        postParams.put("user_id", comId);
        postParams.put("party", platformSign);
        postParams.put("listStr", listStr);
        postParams.put("order_id", orderId);
        postParams.put("inception_date", inceptionDate);
        return HttpUtils.sendHttpRt(
                commonService.getSystemConfig("BLB_URL").replace("https:","http:") + BLBServiceConst.BLB_MINUS_PRESERVATION_URL
                        + "?ACCESS_TOKEN=" + getToken()
                , postParams);
    }

    /**
     * <b> 在保未录入列表人员做减员保全 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result blbMinusPreservationByNotIncluded(String comId, String orderId, String listStr,String inceptionDate){
        Map postParams = Maps.newHashMap();
        String platformSign = commonService.getSystemConfig("PLATFORM_SIGN");
        postParams.put("user_id", comId);
        postParams.put("party", platformSign);
        postParams.put("listStr", listStr);
        postParams.put("order_id", orderId);
        postParams.put("inception_date", inceptionDate);
        return HttpUtils.sendHttpRt(
                commonService.getSystemConfig("BLB_URL").replace("https:","http:") + BLBServiceConst.BLB_SPECIAL_MINUS_PRESERVATION_URL
                        + "?ACCESS_TOKEN=" + getToken()
                , postParams);
    }

    /**
     * <b> 用户信息添加到缓存，返回生成的百联保访问地址 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getCompnayAndPersonPutCacheUrl(String reviseType, String cacheId){
        return commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_CACHE_URL
                + "?revise_type=" + reviseType
                + "&cacheId=" + cacheId
                + "&ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> 订单列表页面链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getBlbOrderPageLinkUrl(String businessType){
        return commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_ORDER_LIST_URL
                + "?businessType="+businessType+"&ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> 理赔列表页面链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getBlbReportPageLinkUrl(){
        return commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_REPORT_LIST_URL
                + "?ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> 保全页面链接生成，不带人员信息 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getBlbPreservationPageLinkUrl(){
        return commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_PRESERVATION_LIST_URL
                + "?ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> 在线企业保险链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public String blbLinkUrl(Long comId, String login_name){
        String platformSign = commonService.getSystemConfig("PLATFORM_SIGN");
        Map<Object, Object> subject = Maps.newHashMap();
        subject.put("user_id", comId);
        subject.put("province", comBaseInfoMapper.getProvinceByID(comId));
        subject.put("login_name", login_name);
        subject.put("party", platformSign);
        String token = JwtUtil.createJWT(subject);
        return commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_PRODUCT_URL
                + "?party=" + platformSign
                + "&token=" + token
                + "&ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> 在线企业保险用户激活链接生成 </b>
     * @author ZXF
     * @create 2021/02/23 0023 13:24
     * @version
     * @注意事项 </b>
     */
    @Override
    public String blbActivateUserLinkUrl(Long comId, String login_name){
        String platformSign = commonService.getSystemConfig("PLATFORM_SIGN");
        Map<Object, Object> subject = Maps.newHashMap();
        subject.put("user_id", comId);
        subject.put("province", comBaseInfoMapper.getProvinceByID(comId));
        subject.put("login_name", login_name);
        subject.put("party", platformSign);
        String token = JwtUtil.createJWT(subject);
        return commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_ACTIVATE_USER_URL
                + "?party=" + platformSign
                + "&token=" + token
                + "&ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> 企业保险详情链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getBlbDetailLinkUrl(String orderId){
        return commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_DETAIL_URL
                + "?order_id=" + orderId
                + "&ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> 企业保全列表的保险详情链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getBlbPreservationLinkUrl(String reviseType, String orderId, String cacheId){
        return commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_PRESERVATION_URL
                + "?revise_type=" + reviseType
                + "&order_id=" + orderId
                + "&cacheId=" + cacheId
                + "&ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> 获得百联保保险产品列表 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getBlbProList(){
        String url = commonService.getSystemConfig("BLB_URL")
                + BLBServiceConst.BLB_PRODUCT_LIST_URL
                + "?ACCESS_TOKEN=" + getToken();
        return HttpUtil.get(url);
    }

    /**
     * <b> 已投保未录入人员身份证去百联保匹配获取姓名 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result blbPerName(String listStr){
        Map postParams = Maps.newHashMap();
        postParams.put("listStr", listStr);
        return HttpUtils.sendHttpRt(
                commonService.getSystemConfig("BLB_URL").replace("https:","http:") + BLBServiceConst.BLB_INS_RESULT_NAME_URL
                        + "?ACCESS_TOKEN=" + getToken()
                , postParams);
    }

    /**
     * <b> 获取保单号对应的在保人数 </b>
     * @author ZXF
     * @create 2020/04/20 0020 10:33
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result blbZBNum(String token,String policyNos){
        Map postParams = Maps.newHashMap();
        postParams.put("token", token);
        postParams.put("policyNos", policyNos);
        return HttpUtils.sendHttpRt(
                commonService.getSystemConfig("BLB_URL").replace("https:","http:") + BLBServiceConst.BLB_INS_ZB_NUM_URL
                        + "?ACCESS_TOKEN=" + getToken()
                , postParams);
    }

    /**
     * <b> 线下保单如果标识百联保购买就去百联保对应订单打上标识 </b>
     * @author ZXF
     * @create 2020/04/20 0020 10:33
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result blbSetSign(String token,String policyNo,String webType){
        Map postParams = Maps.newHashMap();
        postParams.put("token", token);
        postParams.put("policyNo", policyNo);
        postParams.put("webType", webType);
        return HttpUtils.sendHttpRt(
                commonService.getSystemConfig("BLB_URL") + BLBServiceConst.BLB_INS_SET_SIGN_URL
                        + "?ACCESS_TOKEN=" + getToken()
                , postParams);
    }

    /**
     * <b> 通用生成百联保接口地址，带token </b>
     * @author ZXF
     * @create 2020/06/29 0029 14:51
     * @version
     * @注意事项 </b>
     */
    @Override
    public String blbLinkUrl(Long comId, String loginName, String urlBody){
        String platformSign = commonService.getSystemConfig("PLATFORM_SIGN");
        Map<Object, Object> subject = Maps.newHashMap();
        subject.put("user_id", comId);
        subject.put("province", comBaseInfoMapper.getProvinceByID(comId));
        subject.put("login_name", loginName);
        subject.put("party", platformSign);
        String token = JwtUtil.createJWT(subject);
        return commonService.getSystemConfig("BLB_URL")
                + urlBody
                + "?party=" + platformSign
                + "&token=" + token
                + "&ACCESS_TOKEN=" + getToken();
    }

    /**
     * <b> APP理赔列表 </b>
     * @param idCardNo 身份证
     * @param status 理赔状态：0.待提交；1.审核中；2.已结案
     * @author ZXF
     * @create 2020/06/29 0029 15:04
     * @version
     * @注意事项 </b>
     */
    @Override
    public String reportList(String idCardNo,String status, Long comId){
        return blbLinkUrl(comId, "", BLBServiceConst.BLB_APP_REPORT_LIST_URL)+"&saasIdCardNo="+idCardNo+"&status="+status;
    }

    /**
     * <b> 根据身份证查询有过参与投保的保单记录 </b>
     * @author ZXF
     * @create 2020/06/29 0029 18:07
     * @version
     * @注意事项 </b>
     */
    @Override
    public String findPolicyByIdCard(String idCardNo, Long comId){
        return blbLinkUrl(comId, "", BLBServiceConst.BLB_APP_POLICY_FIND_URL)+"&saasIdCardNo="+idCardNo;
    }

    /**
     * <b> APP理赔详情 </b>
     * @param reportId 理赔记录Id
     * @author ZXF
     * @create 2020/06/29 0029 15:06
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getReportById(String reportId,Long comId){
        return blbLinkUrl(comId, "", BLBServiceConst.BLB_APP_REPORT_DETAIL_URL).replace("{reportId}",reportId);
    }

    /**
     * <b> 提交报案信息 </b>
     * @author ZXF
     * @create 2020/06/29 0029 15:23
     * @version
     * @注意事项 </b>
     */
    @Override
    public String saveReport(Long comId){
        return blbLinkUrl(comId, "", BLBServiceConst.BLB_APP_REPORT_SAVE_URL);
    }

    /**
     * <b> 报案理流程附件补传 </b>
     * @author ZXF
     * @create 2020/06/29 0029 15:23
     * @version
     * @注意事项 </b>
     */
    @Override
    public String saveUploadFile(Long comId){
        return blbLinkUrl(comId, "", BLBServiceConst.BLB_APP_REPORT_SAVE_FILE_URL);
    }

    /**
     * <b> 通过图片地址上传到平安ibos平台，激活fileId并返回 </b>
     * @author ZXF
     * @create 2020/06/29 0029 16:35
     * @version
     * @注意事项 </b>
     */
    @Override
    public String getFileIdByPath(String path, Long comId){
        return blbLinkUrl(comId, "", BLBServiceConst.BLB_APP_REPORT_GET_FILEID_URL)+"&path="+path;
    }

    /**
     * <b> 获取saas token </b>
     * @author ZXF
     * @create 2020/09/02 0002 10:16
     * @version
     * @注意事项 </b>
     */
    private static String getToken(){
        HttpServletRequest request = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            return request.getHeader("access_token");
        }
        return "";
    }
}