package com.bcxin.platform.service.bbd;


import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.wallet.ComWalletTransferDTO;

import java.util.List;
import java.util.Map;

/**
 * 百保盾联调
 *
 * @author zhongjianhui
 * @since 2018-03-22 10:04:46
 */
public interface BbdTestService {

    /**
     * 查询待发放补贴列表
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-10-16
     */
    String bbdGetDffSubsidyList(ComWalletTransferDTO dto) throws V5BusinessException;


    /**
     * 获取百保盾补贴详情页面地址
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-10-23
     */
    String bbdGetBbdSubsidyPageUrl(ComWalletTransferDTO dto) throws V5BusinessException;


    /**
     * 同步补贴发放状态
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-10-16
     */
    Result bbdSyncSubsidyGrantStatus(ComWalletTransferDTO dto) throws V5BusinessException;

    /**
     * <b> 同步企业人员投保状态到天翎 </b>
     *
     * @param list {"userID":"122","perId":"100","saas_Id":"100","comId":"300","domain_id":"333","insure":"0"}
     * @author ZXF
     * @create 2020/03/18 0018 10:52
     * @version
     * @注意事项 </b>
     */
    void tlSyncPerPolicyStatus(List<Map> list);
}