package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendCalendar;

import java.util.List;

/**
 * 考勤打卡日历套Service接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendCalendarService{

    /**
     * 查询考勤打卡日历套
     * 
     * @param id 考勤打卡日历套ID
     * @return 考勤打卡日历套
     */
    AttendCalendar findById(Long id);

    /**
     * 查询考勤打卡日历套列表
     * 
     * @param attendCalendar 考勤打卡日历套
     * @return 考勤打卡日历套集合
     */
    List<AttendCalendar> selectList(AttendCalendar attendCalendar);


    /**
     * 编辑考勤打卡日历套
     * 
     * @param attendCalendar 考勤打卡日历套
     * @return 结果
     */
    int update(AttendCalendar attendCalendar);

    /**
     * 批量删除考勤打卡日历套
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

}
