package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendCalendarRest;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;

import java.util.List;

/**
 * 考勤打卡日历套-日历Service接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendCalendarRestService {

    /**
     * 查询考勤打卡日历套-日历
     * 
     * @param id 考勤打卡日历套-日历ID
     * @return 考勤打卡日历套-日历
     */
    AttendCalendarRest findById(Long id);

    /**
     * 查询考勤打卡日历套-日历列表
     * 
     * @param attendCalendarDetail 考勤打卡日历套-日历
     * @return 考勤打卡日历套-日历集合
     */
    List<AttendCalendarRestDetailDto> selectList(AttendCalendarRestDetailDto attendCalendarDetail);


    /**
     * 编辑考勤打卡日历套-日历
     * 
     * @param attendCalendarDetail 考勤打卡日历套-日历
     * @return 结果
     */
    int update(AttendCalendarRest attendCalendarDetail);

    /**
     * 批量删除考勤打卡日历套-日历
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除考勤打卡日历套-日历信息
     * 
     * @param id 考勤打卡日历套-日历ID
     * @return 结果
     */
    int deleteById(Long id);

    int saveBatch(List<AttendCalendarRest> restList);
}
