package com.bcxin.platform.mapper.order;


import com.bcxin.platform.domain.order.ComOrder;
import com.bcxin.platform.dto.order.ComOrderDto;
import com.bcxin.platform.dto.order.ComOrderVo;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 企业订单
 *
 * @author llc
 * @date 2020-01-15
 */
@Component
public interface ComOrderMapper{

    /**
     * 插入企业订单
     * @param comOrder
     * @author llc
     * @date 2020-01-15
     * @return
     */
    int insertComOrder(ComOrder comOrder);


    /**
     * 获取订单列表
     * @param dto
     * @author llc
     * @date 2020-01-17
     * @return
     */
    List<ComOrderDto> getComOrderList(ComOrderDto dto);

    /**
     * 获取订单列表 FOR osp
     * @param dto
     * @author llc
     * @date 2020-01-17
     * @return
     */
    List<ComOrderVo> getOrderList(ComOrderVo dto);

    /**
     * 订单操作：设为已配置（变更订单配置状态）
     * @param dto
     * @return
     */
    int changeDeployStatus(ComOrderDto dto);

    /**
     * 获取统计信息
     * @param dto
     * @author wangjianjun
     * @date 2020-01-17
     * @return
     */
    Map getComOrderStatistic(ComOrderDto dto);

    int update(ComOrder comOrder);

    ComOrder getById(Long comOrderId);

    int selectCount(String orderDeployStatus);
}