package com.bcxin.platform.mapper.company;

import com.bcxin.platform.domain.company.PerOrgRelation;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 人员组织关系Mapper接口
 * 
 * @author task
 * @date 2021-04-09
 */
public interface PerOrgRelationMapper{

    /**
     * 查询人员组织关系
     * 
     * @param perOrgRelationId 人员组织关系ID
     * @return 人员组织关系
     */
    PerOrgRelation selectPerOrgRelationById(Long perOrgRelationId);

    /**
     * 查询人员组织关系列表
     * 
     * @param perOrgRelation 人员组织关系
     * @return 人员组织关系集合
     */
    List<PerOrgRelation> selectPerOrgRelationList(PerOrgRelation perOrgRelation);

    /**
     * 新增人员组织关系
     * 
     * @param perOrgRelation 人员组织关系
     * @return 结果
     */
    int insertPerOrgRelation(PerOrgRelation perOrgRelation);

    /**
     * 修改人员组织关系
     * 
     * @param perOrgRelation 人员组织关系
     * @return 结果
     */
    int updatePerOrgRelation(PerOrgRelation perOrgRelation);

    /**
     * 删除人员组织关系
     * 
     * @param perOrgRelationId 人员组织关系ID
     * @return 结果
     */
    int deletePerOrgRelationById(Long perOrgRelationId);

    /**
     * 批量删除人员组织关系
     * 
     * @param perOrgRelationIds 需要删除的数据ID
     * @return 结果
     */
    int deletePerOrgRelationByIds(String[] perOrgRelationIds);

    /****
     * 保存
     * @param perOrgRelation
     * @return
     */
    int save(PerOrgRelation perOrgRelation);

    /****
     * 选择修改
     * @param perOrgRelation
     * @return
     */
    int updateSelective(PerOrgRelation perOrgRelation);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<PerOrgRelation> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PerOrgRelation> findByBatchId(@Param("list") List<PerOrgRelation> list);

    PerOrgRelation find(PerOrgRelation relation);

    PerOrgRelation findByPerId(Long perId);


    /**
     * 查询企业人数
     * @param comId
     * @return
     * @author llc
     * @date 2019-07-11
     */
    Map<String,Object> getComPerCount(@Param("comId") Long comId);

    /**
     * 获取驻勤模块公共部门树的人员列表
     * @param perOrgRelation
     * @auth llc
     * @date 2020-04-16
     * @return
     */
    List<Map<String,Object>> getTaskDepartPerSonList(PerOrgRelation perOrgRelation);

    /**
     * 获取选人公共部门树的人员列表
     * @param perOrgRelation
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    List<Map<String,Object>> getDepartPerSonList(PerOrgRelation perOrgRelation);

    /**
     * 通过人员ID列表查询人员基础信息
     * @param comId
     * @param perIdList
     * @return
     * @author llc
     * @date 2020-04-15
     */
    List<Map<String,String>> getPerBaseInfoListByPerIds(@Param(value = "comId") Long comId, @Param("perIdList") List<String> perIdList);

    /**
     * 查询人员组织关系
     *
     * @param tlkRelationId v5人员组织关系ID
     * @return 人员组织关系
     */
    PerOrgRelation selectPerOrgRelationByTlkId(String tlkRelationId);

    /**
     * 公共选人的接口(关键字查询)
     * @param comId
     * @param keyWord
     * @return
     * @author llc
     * @date 2019-08-28
     */
    List<Map<String,String>> getCommonPerListByKeyword(@Param("comId") Long comId,@Param("keyWord") String keyWord);


    /**
     * 获取华为会议选人公共部门树的人员列表
     * @param perOrgRelation
     * @auth llc
     * @date 2019-12-12
     * @return
     */
    List<Map<String,Object>> getHuaweiDepartPerSonList(PerOrgRelation perOrgRelation);

    List<PerOrgRelation> selectByTlkIds(@Param("list") List<String> tlkPerIds);
}
