package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.dto.app.AppAttendShiftDto;
import com.bcxin.platform.dto.attend.AttendShiftDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤班次Mapper接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendShiftMapper{

    /**
     * 查询考勤班次
     * 
     * @param id 考勤班次ID
     * @return 考勤班次
     */
    AttendShift findById(Long id);

    /**
     * 查询考勤班次列表
     * 
     * @param attendShift 考勤班次
     * @return 考勤班次集合
     */
    List<AttendShiftDto> selectList(AttendShiftDto attendShift);

    /**
     * 删除考勤班次
     * 
     * @param id 考勤班次ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤班次
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendShift
     * @return
     */
    int save(AttendShift attendShift);

    /****
     * 选择修改
     * @param attendShift
     * @return
     */
    int updateSelective(AttendShift attendShift);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendShift> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendShift> findByBatchId(@Param("list") List<AttendShift> list);

    List<AttendShift> findByArrIds(String[] ids);

    AttendShift findByNameAndAttend(AttendShift attendShift);

    List<AttendShift> findUsedList(String[] ids);

    List<AppAttendShiftDto> findByAttendId(AttendShiftDto attendShift);
}
