package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendLeave;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤请假统计Mapper接口
 * 
 * @author lin
 * @date 2021-09-07
 */
public interface AttendLeaveMapper{

    /**
     * 查询考勤请假统计
     * 
     * @param id 考勤请假统计ID
     * @return 考勤请假统计
     */
    AttendLeave findById(Long id);

    /**
     * 查询考勤请假统计列表
     * 
     * @param attendLeave 考勤请假统计
     * @return 考勤请假统计集合
     */
    List<AttendLeave> selectList(AttendLeave attendLeave);

    List<AttendLeave> selectListGroupDate(AttendLeave attendLeave);

    /**
     * 删除考勤请假统计
     * 
     * @param id 考勤请假统计ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤请假统计
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendLeave
     * @return
     */
    int save(AttendLeave attendLeave);

    /****
     * 选择修改
     * @param attendLeave
     * @return
     */
    int updateSelective(AttendLeave attendLeave);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendLeave> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendLeave> findByBatchId(@Param("list") List<AttendLeave> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendLeave> findByBatchOaLeaveId(@Param("list") List<AttendLeave> list);

}
