package com.bcxin.platform.dto.meeting;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class OrderDTO {

    /**
     * 0：天；
     * 1：周；
     * 2：月；
     * 3：年；
     * 4：小时；
     * 5：绝对时间；
     * 购买会议硬件资源时该字段填5；
     * 购买会议软件资源根据实际购买情况选择2或者3；
     */
    @ApiModelProperty(value = "订购周期类型")
    private String duration_type;
    /**
     * 订购周期数，取值必须大于0；duration_type 不为5时必填。
     * 按月购买最多支持9个月，按年购买最多支持3年
     */
    @ApiModelProperty(value = "订购周期数")
    private String duration;

    /**
     * 不是必填
     */
    @ApiModelProperty(value = "订单的产品资源列表")
    private List<ResourceItemDTO> res_list;

    /**
     * 收货地址标识，由CBC提供的唯一地址，只有当购买资源是硬件资源时才需要填写，例如res_type为hws.resource.type.partnerdevices.maxhub时填写该字段。会议软件资源不需要填写。
     * 不是必填
     */
    @ApiModelProperty(value = "收货地址标识")
    private String delivery_address_id;

}
