package com.bcxin.platform.dto.meeting;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <b> 会议其他配置信息 </b>
 *
 * @author ZXF
 * @create 2020/01/13 0013 15:04
 * @注意事项 </b>
 */
@Data
public class ConfConfigInfoDTO {

    /**
     * 会议视频模式类型,FREE：自由模式,FIXED：固定画面广播模式,RollCall：点名模式,BROADCAST：广播模式
     */
    @ApiModelProperty(value = "会议视频模式类型")
    private String videoConfMode;


    /**
     * 会议邀请模式,AUTO_INVITE：自动邀请,MANUAL_INVITE：手动邀请,DISABLE_INVITE：禁止邀请,DELAY_INVITE：延迟邀请
     */
    @ApiModelProperty(value = "会议邀请模式")
    private String inviteMode;


    /**
     * 会议自动延长情况下，每次延长时间，单位：分钟，最大60 默认值由会议模板决定
     */
    @ApiModelProperty(value = "会议自动延长")
    private Integer prolongLength;


    /**
     * 会议调度模式,AUTO_DISPATCH：会议到点自动调度,MANUAL_DISPATCH：会议到点不自动调度，第一个与会人入会触发会议调度
     */
    @ApiModelProperty(value = "会议调度模式")
    private String dispatchMode;

    /**
     * 来宾是否免密,True：免密,False：不免密
     */
    @ApiModelProperty(value = "来宾是否免密")
    private String isGuestFreePwd = "False";


    /**
     * 是否需要发送会议邮件通知,True：需要,False：不需要
     */
    @ApiModelProperty(value = "是否需要发送会议邮件通知")
    private String isSendNotify = "False";

    /**
     * 是否需要发送会议通知,True：需要,False：不需要
     */
    @ApiModelProperty(value = "是否需要发送会议通知")
    private String isSendSms = "False";

    /**
     * 是否需要发送会议通知,True：需要,False：不需要
     */
    @ApiModelProperty(value = "是否需要发送会议通知")
    private String isSendCalendar = "False";

    /**
     * 是否自动静音 默认值由会议模板决定
     */
    @ApiModelProperty(value = "是否自动静音 默认值由会议模板决定")
    private String isAutoMute;
}
