package com.bcxin.platform.dto.company;

import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.util.constants.CommonConst;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * @author：wangcy @date：2017/12/23 0023 10:24 @description：
 */
@Data
public class ComBaseInfoDto extends ComBaseInfo {

	private String message;

	/**
	 * 企业管理员手机
	 */
	private String adminPhone;

	/**
	 * 百保盾对接：企业用户名
	 */
	private String userName;

	/**
	 * 是否推送注册信息到子系统，默认推送
	 */
	private String pushRegister = CommonConst.Y;

	private String bxgzContent;

	private Long fgsSetComId;

	/**
	 * 是否百保盾注册
	 */
	private String isBbdRegister;

	/**
	 * 主管理员ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long perId;

	/**
	 * 安全范围(以逗号分隔)
	 */
	private String safeRange;

}
