package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * @author linqinglin
 * @date 2021/08/18 0018 9:29
 */
@Data
public class AttendDto extends BaseEntity {


    /** 是否启用 1是0否 */
    private String active;

    /** 名称 */
    private String attendName;

    private String searchValue;

    /** 公司ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /**
     * 人员id
     */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;
}
