package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author linqinglin
 * @date 2021/08/27 0027 14:36
 */
@Data
public class AttendClockStateDto extends BaseEntity {

    /** 人员ID */
    @Excel(name = "人员ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    @NotBlank(message="是否启用不能为空", groups = {AddGroup.class, UpdateGroup.class})
    String ids;
}
