package com.bcxin.platform.dto.app;

import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

/**
 * @author linqinglin
 * @date 2021/09/16 0016 10:16
 */
@Data
public class AppAttendSchedulClockDto extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 排班ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long schedulDetailId;

    /**
     * 班次名称
     */
    private String ShiftName;

    /** 上班日期 */
    private String schedulDate;

    /** 上班时间 */
    private String startTime;

    /** 下班时间 */
    private String endTime;

    /** 是否需要休息 1是0否*/
    private String needRest;

    /** 休息开始时间 */
    private String restStart;

    /** 休息结束时间 */
    private String restEnd;

    /** 上班打卡时间 */
    private String clockStart;

    /** 下班打卡时间 */
    private String clockEnd;

    /** 打卡状态 1正常2缺卡3迟到4早退5缺勤6补卡11请假21上班缺卡22下班缺卡34迟到早退61上班补卡62下班补卡610上班补卡审批中620下班补卡审批中*/
    private String clockStatus;

    /** 早退分钟数 */
    private Integer leaveEarly;

    /** 迟到分钟数 */
    private Integer lateMin;

    /** 上班打卡状态 11请假6补卡审批中61补卡通过*/
    private String startStatus;

    /** 下班打卡状态 11请假6补卡审批中61补卡通过*/
    private String endStatus;

    /*班次类型 1计时班次 2 计次班次*/
    private String shiftType;

}
