package com.bcxin.platform.domain.wallet;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <b> 个人钱包账户 </b>
 * @author ZXF
 * @create 2019/09/02 0002 14:39
 * @version
 * @注意事项 </b>
 */
@Data
@TableName("com_wallet_account")
public class PerWalletAccount {

	/** 人员ID */
	@ApiModelProperty(value = "人员ID")
	private Long perId;

	/** 公司名称 */
	@ApiModelProperty(value = "姓名")
	private String name;

	/** 证件号码 */
	@ApiModelProperty(value = "证件号码")
	private String idCardNo;

	/** 身份证正面url */
	@ApiModelProperty(value = "身份证正面url")
	private String idCardFrontUrl;

	/** 身份证反面url */
	@ApiModelProperty(value = "身份证反面url")
	private String idCardReverseUrl;

	/** 手机号 */
	@ApiModelProperty(value = "手机号")
	private String mobilePhone;

	/** 银行简称 */
	@ApiModelProperty(value = "银行简称")
	private String bankCode;

	/** 银行卡号 */
	@ApiModelProperty(value = "银行卡号")
	private String bankCardNo;

	/** 钱包账户号 */
	@ApiModelProperty(value = "钱包账户号")
	private String walletAccountNo;

	private Long createBy; // 创建者
	private Date createTime; // 创建日期
	private Long updateBy; // 更新者
	private Date updateTime = new Date(); // 更新日期

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getUpdateTime() {
		return updateTime;
	}
}