package com.bcxin.platform.domain.product;

import com.bcxin.platform.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 产品购买方式
 * 
 * @author llc
 * @date 2020-01-14
 */
@Data
@TableName("config_product_buy_mode")
public class ConfigProductBuyMode{

	/** 产品购买方式ID */
	@ApiModelProperty(value = "产品购买方式ID")
	private String productBuyModeId;

	/** 产品ID */
	@ApiModelProperty(value = "产品ID")
	private String productId;

	/** 是否可用 */
	@ApiModelProperty(value = "是否可用")
	private String isActive;

	/** 购买方式 */
	@ApiModelProperty(value = "购买方式")
	private String productBuyMode;

	/** 费用 */
	@ApiModelProperty(value = "费用")
	private BigDecimal amount;

	/** 单位 */
	@ApiModelProperty(value = "单位")
	private String unit;

}