package com.bcxin.platform.domain.order;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 企业订单
 * 
 * @author llc
 * @date 2020-01-15
 */
@Data
@TableName("com_order")
public class ComOrder extends BaseEntity<ComOrder> {

	/** 企业订单ID */
	@ApiModelProperty(value = "企业订单ID")
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long comOrderId;

	/** 产品范畴类型 */
	@ApiModelProperty(value = "产品范畴类型")
	private String productCategoryType;

	/** 订单状态 */
	@ApiModelProperty(value = "订单状态")
	private String orderStatus;

	/** 资源采购状态 */
	@ApiModelProperty(value = "资源采购状态")
	private String purchaseStatus;

	/** 收货地址 */
	@ApiModelProperty(value = "收货地址")
	private String deliveryAddress;

	/** 订单金额 */
	@ApiModelProperty(value = "订单金额")
	private BigDecimal amount;

	/** 实际支付金额 */
	@ApiModelProperty(value = "实际支付金额")
	private BigDecimal actualPayAmount;

	/** 分配状态 */
	@ApiModelProperty(value = "分配状态")
	private String orderDeployStatus;

	/** 分配组织类型 */
	@ApiModelProperty(value = "分配组织类型")
	private String assignedOrgType;

	/** 分配组织ID */
	@ApiModelProperty(value = "分配组织ID")
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long assignedOrgId;

}